/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.parser.AssignExpr;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.CallExpr;
import com.caucho.es.parser.DeleteExpr;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.PostfixExpr;
import java.io.IOException;

class FieldExpr
extends Expr {
    Expr lhs;
    Expr field;

    FieldExpr(Block block, Expr lhs, Expr field) {
        super(block);
        this.lhs = lhs;
        this.field = field;
        if (lhs != null) {
            lhs.setUsed();
        }
        if (field != null) {
            field.setUsed();
        }
    }

    Expr getExpr() {
        return this.lhs;
    }

    Expr getField() {
        return this.field;
    }

    int getType() {
        return 1;
    }

    Expr assign(Expr value) throws ESException {
        return new AssignExpr(this.block, this.lhs, this.field, value);
    }

    Expr delete() {
        return new DeleteExpr(this.block, this.lhs, this.field);
    }

    Expr prefix(int op) {
        if (op == 43) {
            return new PostfixExpr(this.block, 105, this);
        }
        return new PostfixExpr(this.block, 100, this);
    }

    Expr postfix(int op) {
        if (op == 43) {
            return new PostfixExpr(this.block, 73, this);
        }
        return new PostfixExpr(this.block, 68, this);
    }

    CallExpr startCall() throws ESException {
        return new CallExpr(this.block, this.lhs, this.field, false);
    }

    CallExpr startNew() throws ESException {
        return new CallExpr(this.block, this.lhs, this.field, true);
    }

    void printImpl() throws IOException {
        this.lhs.print();
        this.cl.print(".getProperty(");
        this.field.printStr();
        this.cl.print(")");
    }
}

