/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.Version;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESFactory;
import com.caucho.es.ESParseException;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;

public class Resin {
    static final String COPYRIGHT = "Copyright (c) 1998-2004 Caucho Technology.  All rights reserved.";
    private static WriteStream dbg;

    private Resin() {
    }

    public static void init(ESFactory factory) {
        ESBase.init(factory);
    }

    public static Parser getParser() throws IOException, ESException {
        Resin.init(null);
        return new Parser();
    }

    public static void main(String[] argv) {
        String resinConf = CauchoSystem.getResinConfig();
        boolean verbose = false;
        try {
            String name;
            ReadStream is;
            int shift = 0;
            while (argv.length > shift) {
                if (argv[shift].equals("-v")) {
                    verbose = true;
                    ++shift;
                    continue;
                }
                if (shift + 1 < argv.length && argv[shift].equals("-conf")) {
                    resinConf = argv[shift + 1];
                    shift += 2;
                    continue;
                }
                if (!argv[shift].equals("--version")) break;
                System.out.println(Version.VERSION);
                System.exit(0);
            }
            if (argv.length == shift) {
                is = VfsStream.openRead(System.in);
                name = "stdin";
            } else {
                is = Vfs.lookupNative(argv[shift]).openRead();
                name = argv[shift++];
            }
            Path conf = Vfs.lookup(resinConf);
            Registry.setDefault(Registry.parse(conf));
            String[] args = argv.length > shift ? new String[argv.length - shift] : new String[]{};
            for (int i = 0; i < argv.length - shift; ++i) {
                args[i] = argv[i + shift];
            }
            MergePath scriptPath = null;
            int p = name.lastIndexOf(47);
            if (p >= 0) {
                Path subpath = Vfs.lookupNative(name.substring(0, p));
                MergePath mergePath = new MergePath();
                mergePath.addMergePath(Vfs.lookup());
                mergePath.addMergePath(subpath);
                mergePath.addMergePath(CauchoSystem.getResinHome().lookup("scripts"));
                mergePath.addClassPath(Thread.currentThread().getContextClassLoader());
                scriptPath = mergePath;
            }
            Parser parser = new Parser();
            parser.setScriptPath(scriptPath);
            Script script = parser.parse(is);
            WriteStream stream = VfsStream.openWrite(System.out);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("out", stream);
            properties.put("arguments", args);
            properties.put("File", Vfs.lookup());
            script.execute(properties, null);
            stream.flush();
        }
        catch (ESParseException e) {
            System.err.println(e.getMessage());
        }
        catch (ESException e) {
            System.err.println(e.getMessage());
            if (verbose) {
                e.printStackTrace();
            } else {
                e.printESStackTrace();
            }
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
    }
}

