/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESRegexp;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.es.Printf;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;

class NativeString
extends Native {
    static final int NEW = 1;
    static final int TO_STRING = 2;
    static final int FROM_CHAR_CODE = 3;
    static final int VALUE_OF = 4;
    static final int CHAR_AT = 5;
    static final int CHAR_CODE_AT = 6;
    static final int INDEX_OF = 7;
    static final int LAST_INDEX_OF = 8;
    static final int SPLIT = 9;
    static final int SUBSTRING = 10;
    static final int TO_UPPER_CASE = 11;
    static final int TO_LOWER_CASE = 12;
    static final int CONCAT = 13;
    static final int MATCH = 14;
    static final int REPLACE = 15;
    static final int SEARCH = 16;
    static final int SLICE = 17;
    static final int SUBSTR = 18;
    static final int PRINTF = 19;
    static final int CONTAINS = 20;
    static final int STARTS_WITH = 21;
    static final int ENDS_WITH = 22;
    static final int GET_BYTES = 23;
    static final int REPLACE_WS = 0;
    static final int REPLACE_DIGIT = 1;
    static final int REPLACE_ID = 2;

    private NativeString(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        NativeString nativeString = new NativeString("String", 1, 1);
        ESWrapper stringProto = new ESWrapper("String", (ESBase)resin.objProto, ESString.NULL);
        NativeWrapper string = new NativeWrapper(resin, nativeString, stringProto, 7);
        resin.stringProto = stringProto;
        stringProto.put("length", (ESBase)ESNumber.create(0.0), 7);
        NativeString.put(stringProto, "valueOf", 4, 0);
        NativeString.put(stringProto, "toString", 2, 0);
        NativeString.put(stringProto, "charAt", 5, 1);
        NativeString.put(stringProto, "charCodeAt", 6, 1);
        NativeString.put(stringProto, "indexOf", 7, 2);
        NativeString.put(stringProto, "lastIndexOf", 8, 2);
        NativeString.put(stringProto, "split", 9, 1);
        NativeString.put(stringProto, "substring", 10, 2);
        NativeString.put(stringProto, "toUpperCase", 11, 0);
        NativeString.put(stringProto, "toLowerCase", 12, 0);
        NativeString.put(string, "fromCharCode", 3, 0);
        NativeString.put(stringProto, "concat", 13, 1);
        NativeString.put(stringProto, "match", 14, 1);
        NativeString.put(stringProto, "replace", 15, 2);
        NativeString.put(stringProto, "search", 16, 1);
        NativeString.put(stringProto, "slice", 17, 2);
        NativeString.put(stringProto, "substr", 18, 2);
        NativeString.put(string, "printf", 19, 1);
        NativeString.put(stringProto, "contains", 20, 1);
        NativeString.put(stringProto, "startsWith", 21, 1);
        NativeString.put(stringProto, "endsWith", 22, 1);
        NativeString.put(stringProto, "getBytes", 23, 1);
        stringProto.setClean();
        string.setClean();
        return string;
    }

    private static void put(ESObject obj, String name, int n, int len) {
        ESId id = ESId.intern(name);
        obj.put(id, (ESBase)new NativeString(name, n, len), 4);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                if (length == 0) {
                    return ESString.create("");
                }
                return eval.getArg(0).toStr();
            }
            case 3: {
                return this.fromCharCode(eval, length);
            }
            case 2: 
            case 4: {
                try {
                    return ((ESWrapper)eval.getArg((int)-1)).value;
                }
                catch (ClassCastException e) {
                    if (eval.getArg(-1) instanceof ESString) {
                        return eval.getArg(-1);
                    }
                    if (eval.getArg(-1) instanceof ESThunk) {
                        return ((ESWrapper)((ESThunk)eval.getArg((int)-1)).getObject()).value;
                    }
                    throw new ESException("toString expects string object");
                }
            }
            case 5: {
                return this.charAt(eval, length);
            }
            case 6: {
                return this.charCodeAt(eval, length);
            }
            case 7: {
                return this.indexOf(eval, length);
            }
            case 8: {
                return this.lastIndexOf(eval, length);
            }
            case 9: {
                return this.split(eval, length);
            }
            case 10: {
                return this.substring(eval, length);
            }
            case 11: {
                return eval.getArg(-1).toStr().toUpperCase();
            }
            case 12: {
                return eval.getArg(-1).toStr().toLowerCase();
            }
            case 13: {
                return this.concat(eval, length);
            }
            case 14: {
                return this.match(eval, length);
            }
            case 15: {
                return this.replace(eval, length);
            }
            case 16: {
                return this.search(eval, length);
            }
            case 17: {
                return this.slice(eval, length);
            }
            case 18: {
                return this.substr(eval, length);
            }
            case 19: {
                return this.printf(eval, length);
            }
            case 20: {
                if (length < 1) {
                    return ESBoolean.FALSE;
                }
                return eval.getArg(-1).toStr().contains(eval.getArg(0));
            }
            case 21: {
                if (length < 1) {
                    return ESBoolean.FALSE;
                }
                return eval.getArg(-1).toStr().startsWith(eval.getArg(0));
            }
            case 22: {
                if (length < 1) {
                    return ESBoolean.FALSE;
                }
                return eval.getArg(-1).toStr().endsWith(eval.getArg(0));
            }
            case 23: {
                if (length < 1) {
                    return eval.wrap(eval.getArgString(-1, length).getBytes());
                }
                return eval.wrap(eval.getArgString(-1, length).getBytes(eval.getArgString(0, length)));
            }
        }
        throw new ESException("Unknown object function");
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.n != 1) {
            throw new ESException("Unknown object function");
        }
        return (ESObject)this.create(eval, length);
    }

    private ESBase create(Call eval, int length) throws Throwable {
        ESString value = length == 0 ? ESString.create("") : eval.getArg(0).toStr();
        return ((ESBase)value).toObject();
    }

    private ESBase fromCharCode(Call eval, int length) throws Throwable {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int value = eval.getArg(i).toInt32() & 0xFFFF;
            sbuf.append((char)value);
        }
        return ESString.create(sbuf.toString());
    }

    private ESBase charAt(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return ESString.create("");
        }
        int value = (int)eval.getArg(0).toNum();
        if (value < 0 || value >= string.length()) {
            return ESString.create("");
        }
        return ESString.create("" + string.charAt(value));
    }

    private ESBase charCodeAt(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return ESNumber.NaN;
        }
        int value = (int)eval.getArg(0).toNum();
        if (value < 0 || value >= string.length()) {
            return ESNumber.NaN;
        }
        return ESNumber.create(string.charAt(value));
    }

    private ESBase indexOf(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return ESNumber.create(-1.0);
        }
        int pos = 0;
        if (length > 1) {
            pos = (int)eval.getArg(1).toNum();
        }
        ESString test = eval.getArg(0).toStr();
        return ESNumber.create(string.indexOf(test, pos));
    }

    private ESBase lastIndexOf(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return ESNumber.create(-1.0);
        }
        int pos = string.length() + 1;
        if (length > 1) {
            pos = (int)eval.getArg(1).toNum();
        }
        ESString test = eval.getArg(0).toStr();
        return ESNumber.create(string.lastIndexOf(test, pos));
    }

    private String escapeRegexp(String arg) {
        CharBuffer cb = new CharBuffer();
        block3: for (int i = 0; i < arg.length(); ++i) {
            char ch = arg.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    cb.append('\\');
                    cb.append(ch);
                    continue block3;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.toString();
    }

    private ESBase split(Call eval, int length) throws Throwable {
        Global resin = Global.getGlobalProto();
        ESString string = eval.getArg(-1).toStr();
        ESArray array = resin.createArray();
        if (length == 0) {
            array.setProperty(0, (ESBase)string);
            return array;
        }
        if (eval.getArg(0) instanceof ESRegexp) {
            throw new UnsupportedOperationException();
        }
        String arg = eval.getArg(0).toString();
        String[] values = string.toString().split(arg);
        for (int i = 0; i < values.length; ++i) {
            array.setProperty(i, (ESBase)ESString.create(values[i]));
        }
        return array;
    }

    private ESBase substring(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return string;
        }
        int start = (int)eval.getArg(0).toNum();
        int end = string.length();
        if (length > 1) {
            end = (int)eval.getArg(1).toNum();
        }
        if (start < 0) {
            start = 0;
        }
        if (end > string.length()) {
            end = string.length();
        }
        if (start > end) {
            return string.substring(end, start);
        }
        return string.substring(start, end);
    }

    private ESBase concat(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return string;
        }
        CharBuffer cb = new CharBuffer();
        cb.append(string.toString());
        for (int i = 0; i < length; ++i) {
            ESString next = eval.getArg(i).toStr();
            cb.append(next.toString());
        }
        return ESString.create(cb);
    }

    private ESBase match(Call eval, int length) throws Throwable {
        return esNull;
    }

    private void replaceFun(CharBuffer result, String pattern, ESRegexp regexp, ESBase fun) throws Throwable {
    }

    private ESBase replace(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length < 1) {
            return string;
        }
        Global resin = Global.getGlobalProto();
        ESBase arg = eval.getArg(0);
        if (arg instanceof ESRegexp) {
            ESRegexp regexp = (ESRegexp)arg;
        } else {
            ESRegexp regexp = new ESRegexp(arg.toStr(), ESString.NULL);
        }
        IntArray results = new IntArray();
        String pattern = string.toString();
        ESBase replace = null;
        Object stringPattern = null;
        if (length > 1) {
            replace = eval.getArg(1);
        }
        return null;
    }

    private ESBase search(Call eval, int length) throws Throwable {
        if (length == 0) {
            return ESNumber.create(-1.0);
        }
        return ESNumber.create(-1.0);
    }

    private ESBase slice(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return string;
        }
        int start = (int)eval.getArg(0).toNum();
        int end = string.length();
        if (length > 1) {
            end = (int)eval.getArg(1).toNum();
        }
        if (start < 0) {
            start += string.length();
        }
        if (end < 0) {
            end += string.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (start > string.length()) {
            start = string.length();
        }
        if (end < 0) {
            end = 0;
        }
        if (end > string.length()) {
            end = string.length();
        }
        if (start <= end) {
            return string.substring(start, end);
        }
        return ESString.NULL;
    }

    private ESBase substr(Call eval, int length) throws Throwable {
        ESString string = eval.getArg(-1).toStr();
        if (length == 0) {
            return string;
        }
        int start = (int)eval.getArg(0).toNum();
        int len = string.length();
        if (length > 1) {
            len = (int)eval.getArg(1).toNum();
        }
        if (start < 0) {
            start += string.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (start > string.length()) {
            start = string.length();
        }
        if (len <= 0) {
            return ESString.NULL;
        }
        int end = start + len;
        if (end > string.length()) {
            end = string.length();
        }
        return string.substring(start, end);
    }

    private ESBase printf(Call eval, int length) throws Throwable {
        if (length == 0) {
            return ESString.NULL;
        }
        ESString format = eval.getArg(0).toStr();
        CharBuffer cb = new CharBuffer();
        Printf.printf(cb, format, eval, length);
        return ESString.create(cb.toString());
    }
}

