/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;

class NativeArray
extends Native {
    static ESId LENGTH = ESId.intern("length");
    static final int NEW = 1;
    static final int JOIN = 2;
    static final int TO_STRING = 3;
    static final int REVERSE = 4;
    static final int SORT = 5;
    static final int CONCAT = 6;
    static final int POP = 7;
    static final int PUSH = 8;
    static final int SHIFT = 9;
    static final int UNSHIFT = 10;
    static final int SLICE = 11;
    static final int SPLICE = 12;

    private NativeArray(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static ESObject create(Global resin) {
        NativeArray nativeArray = new NativeArray("Array", 1, 1);
        ESArray proto = new ESArray();
        proto.prototype = resin.objProto;
        NativeWrapper array = new NativeWrapper(resin, nativeArray, proto, 5);
        resin.arrayProto = proto;
        NativeArray.put(proto, "join", 2, 1);
        NativeArray.put(proto, "toString", 3, 0);
        NativeArray.put(proto, "reverse", 4, 0);
        NativeArray.put(proto, "sort", 5, 0);
        NativeArray.put(proto, "concat", 6, 0);
        NativeArray.put(proto, "pop", 7, 0);
        NativeArray.put(proto, "push", 8, 0);
        NativeArray.put(proto, "shift", 9, 0);
        NativeArray.put(proto, "unshift", 10, 0);
        NativeArray.put(proto, "slice", 11, 2);
        NativeArray.put(proto, "splice", 12, 0);
        proto.setClean();
        array.setClean();
        return array;
    }

    private static void put(ESObject obj, String name, int n, int len) {
        ESId id = ESId.intern(name);
        obj.put(id, (ESBase)new NativeArray(name, n, len), 4);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 1: {
                return this.create(eval, length);
            }
            case 2: {
                if (length == 0) {
                    return this.toString(eval, length);
                }
                return this.join(eval, length);
            }
            case 3: {
                return this.toString(eval, length);
            }
            case 4: {
                return this.reverse(eval, length);
            }
            case 5: {
                return this.sort(eval, length);
            }
            case 6: {
                return this.concat(eval, length);
            }
            case 7: {
                return this.pop(eval, length);
            }
            case 8: {
                return this.push(eval, length);
            }
            case 9: {
                return this.shift(eval, length);
            }
            case 10: {
                return this.unshift(eval, length);
            }
            case 11: {
                return this.slice(eval, length);
            }
            case 12: {
                return this.splice(eval, length);
            }
        }
        throw new ESException("Unknown object function");
    }

    ESBase create(Call eval, int length) throws Throwable {
        ESArray obj = Global.getGlobalProto().createArray();
        if (length == 0) {
            return obj;
        }
        if (length == 1) {
            ESBase arg = eval.getArg(0);
            if (arg instanceof ESNumber) {
                ((ESObject)obj).setProperty(LENGTH, (ESBase)ESNumber.create(arg.toInt32()));
            } else {
                ((ESBase)obj).setProperty(0, arg);
            }
            return obj;
        }
        for (int i = 0; i < length; ++i) {
            ((ESBase)obj).setProperty(i, eval.getArg(i));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ESBase join(ESObject array, String separator) throws Throwable {
        if (array.mark != 0) {
            return ESString.create("...");
        }
        array.mark = -1;
        try {
            int len = array.getProperty(LENGTH).toInt32();
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                ESBase value;
                if (i != 0) {
                    sbuf.append(separator);
                }
                if ((value = array.hasProperty(i)) == null || value == esNull || value == esUndefined) continue;
                sbuf.append(value.toString());
            }
            ESString eSString = ESString.create(sbuf.toString());
            return eSString;
        }
        finally {
            array.mark = 0;
        }
    }

    ESBase join(Call eval, int length) throws Throwable {
        String separator = length == 0 ? "," : eval.getArg(0).toString();
        ESObject array = eval.getArg(-1).toObject();
        return NativeArray.join(array, separator);
    }

    static ESBase toString(ESObject array) throws Throwable {
        return NativeArray.join(array, ",");
    }

    ESBase toString(Call eval, int length) throws Throwable {
        ESObject array = eval.getArg(-1).toObject();
        return NativeArray.toString(array);
    }

    ESBase reverse(Call eval, int length) throws Throwable {
        ESObject array = eval.getArg(-1).toObject();
        int len = array.getProperty(LENGTH).toInt32();
        for (int k = 0; k < len / 2; ++k) {
            int firstIndex = k;
            int secondIndex = len - k - 1;
            ESBase first = array.hasProperty(firstIndex);
            ESBase second = array.hasProperty(secondIndex);
            if (first == null) {
                array.delete(secondIndex);
            } else {
                array.setProperty(secondIndex, first);
            }
            if (second == null) {
                array.delete(firstIndex);
                continue;
            }
            array.setProperty(firstIndex, second);
        }
        return array;
    }

    ESBase sort(Call eval, int length) throws Throwable {
        int i;
        ESObject array = eval.getArg(-1).toObject();
        ESBase cmp = length == 0 ? null : eval.getArg(0);
        int len = array.getProperty(LENGTH).toInt32();
        ESBase[] values = new ESBase[len];
        for (i = 0; i < len; ++i) {
            values[i] = array.getProperty("" + i);
        }
        this.qsort(values, 0, len, cmp);
        for (i = 0; i < len; ++i) {
            if (values[i] == esUndefined) {
                array.delete("" + i);
                continue;
            }
            array.setProperty("" + i, values[i]);
        }
        return array;
    }

    private void qsort(ESBase[] array, int offset, int length, ESBase cmp) throws Throwable {
        if (length == 2) {
            if (this.compare(cmp, array[offset], array[offset + 1]) > 0) {
                ESBase temp = array[offset];
                array[offset] = array[offset + 1];
                array[offset + 1] = temp;
            }
        } else if (length > 2) {
            int i;
            int keyIndex = offset + length / 2;
            ESBase key = array[keyIndex];
            int keys = 0;
            int tail = 0;
            int val = this.compare(cmp, array[offset], key);
            if (val > 0) {
                key = array[offset];
                array[offset] = array[keyIndex];
                array[keyIndex] = key;
            } else if (val == 0) {
                ++keys;
            }
            val = this.compare(cmp, key, array[offset + length - 1]);
            if (val > 0) {
                key = array[offset + length - 1];
                array[offset + length - 1] = array[keyIndex];
                array[keyIndex] = key;
                keys = 0;
                tail = 1;
                val = this.compare(cmp, array[offset], key);
                if (val > 0) {
                    key = array[offset];
                    array[offset] = array[keyIndex];
                    array[keyIndex] = key;
                } else if (val == 0) {
                    ++keys;
                }
            } else if (val < 0) {
                tail = 1;
            }
            if (keyIndex == offset + 1) {
                i = 2 + tail;
                ++keys;
            } else {
                i = 1 + tail;
            }
            while (i < length) {
                int index = offset + i - tail;
                if (array[index] == key) {
                    ++keys;
                } else {
                    ESBase temp;
                    int cmpResult = this.compare(cmp, key, array[index]);
                    if (cmpResult > 0 && keys != 0) {
                        temp = array[index];
                        array[index] = array[index - keys];
                        array[index - keys] = temp;
                    } else if (cmpResult < 0) {
                        temp = array[offset + length - tail - 1];
                        array[offset + length - tail - 1] = array[index];
                        array[index] = temp;
                        ++tail;
                    } else if (cmpResult == 0) {
                        ++keys;
                    }
                }
                ++i;
            }
            if (length - tail - keys > 1) {
                this.qsort(array, offset, length - tail - keys, cmp);
            }
            if (tail > 1) {
                this.qsort(array, offset + length - tail, tail, cmp);
            }
        }
    }

    private int compare(ESBase cmp, ESBase a, ESBase b) throws Throwable {
        if (a == b) {
            return 0;
        }
        if (a == esUndefined) {
            return 1;
        }
        if (b == esUndefined) {
            return -1;
        }
        if (a == esNull) {
            return 1;
        }
        if (b == esNull) {
            return -1;
        }
        if (cmp != null) {
            Global resin = Global.getGlobalProto();
            Call eval = resin.getCall();
            eval.stack[0] = esNull;
            eval.stack[1] = a;
            eval.stack[2] = b;
            eval.top = 1;
            int result = cmp.call(eval, 2).toInt32();
            resin.freeCall(eval);
            return result;
        }
        String sa = a.toString();
        String sb = b.toString();
        return sa.compareTo(sb);
    }

    ESBase concat(Call eval, int length) throws Throwable {
        ESArray array = Global.getGlobalProto().createArray();
        int k = 0;
        for (int i = -1; i < length; ++i) {
            ESBase arg = eval.getArg(i);
            if (arg == esNull || arg == esUndefined || arg == esEmpty) continue;
            ESBase arglen = arg.hasProperty(LENGTH);
            if (arglen == null) {
                array.setProperty(k++, arg);
                continue;
            }
            int len = arglen.toInt32();
            if (len < 0) {
                array.setProperty(k++, arg);
                continue;
            }
            for (int j = 0; j < len; ++j) {
                ESBase obj = arg.hasProperty(j);
                if (obj != null) {
                    array.setProperty(k, obj);
                }
                ++k;
            }
        }
        array.setProperty(LENGTH, (ESBase)ESNumber.create(k));
        return array;
    }

    ESBase pop(Call eval, int length) throws Throwable {
        int len;
        ESObject obj = eval.getArg(-1).toObject();
        ESBase lenObj = obj.hasProperty(LENGTH);
        if (lenObj == null || (len = lenObj.toInt32()) <= 0) {
            return esUndefined;
        }
        ESBase value = obj.getProperty(len - 1);
        obj.setProperty(LENGTH, (ESBase)ESNumber.create(len - 1));
        return value;
    }

    ESBase push(Call eval, int length) throws Throwable {
        ESObject obj = eval.getArg(-1).toObject();
        ESBase lenObj = obj.getProperty(LENGTH);
        int len = lenObj.toInt32();
        if (len < 0) {
            len = 0;
        }
        for (int i = 0; i < length; ++i) {
            obj.setProperty(len + i, eval.getArg(i));
        }
        ESNumber newLen = ESNumber.create(len + length);
        obj.setProperty(LENGTH, (ESBase)newLen);
        return newLen;
    }

    ESBase shift(Call eval, int length) throws Throwable {
        int len;
        ESObject obj = eval.getArg(-1).toObject();
        ESBase lenObj = obj.hasProperty(LENGTH);
        if (lenObj == null || (len = lenObj.toInt32()) <= 0) {
            return esUndefined;
        }
        ESBase value = obj.getProperty(0);
        for (int i = 1; i < len; ++i) {
            ESBase temp = obj.hasProperty(i);
            if (temp == null) {
                obj.delete(ESString.create(i - 1));
                continue;
            }
            obj.setProperty(i - 1, temp);
        }
        obj.setProperty(LENGTH, (ESBase)ESNumber.create(len - 1));
        return value;
    }

    ESBase unshift(Call eval, int length) throws Throwable {
        ESBase value;
        int i;
        ESObject obj = eval.getArg(-1).toObject();
        ESBase lenObj = obj.getProperty(LENGTH);
        int len = lenObj.toInt32();
        if (len < 0) {
            len = 0;
        }
        if (length == 0) {
            return ESNumber.create(0.0);
        }
        for (i = len - 1; i >= 0; --i) {
            value = obj.getProperty(i);
            if (value == null) {
                obj.delete(ESString.create(length + i));
                continue;
            }
            obj.setProperty(length + i, value);
        }
        for (i = 0; i < length; ++i) {
            value = eval.getArg(i);
            if (value == null) {
                obj.delete(ESString.create(i));
                continue;
            }
            obj.setProperty(i, value);
        }
        ESNumber numLen = ESNumber.create(len + length);
        obj.setProperty(LENGTH, (ESBase)numLen);
        return numLen;
    }

    ESBase slice(Call eval, int length) throws Throwable {
        ESObject obj = eval.getArg(-1).toObject();
        ESBase lenObj = obj.getProperty(LENGTH);
        int len = lenObj.toInt32();
        ESArray array = Global.getGlobalProto().createArray();
        if (len <= 0) {
            return array;
        }
        int start = 0;
        if (length > 0) {
            start = eval.getArg(0).toInt32();
        }
        if (start < 0) {
            start += len;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > len) {
            return array;
        }
        int end = len;
        if (length > 1) {
            end = eval.getArg(1).toInt32();
        }
        if (end < 0) {
            end += len;
        }
        if (end < 0) {
            return array;
        }
        if (end > len) {
            end = len;
        }
        if (start >= end) {
            return array;
        }
        for (int i = 0; i < end - start; ++i) {
            ESBase value = obj.hasProperty(start + i);
            if (value == null) continue;
            array.setProperty(i, value);
        }
        array.setProperty(LENGTH, (ESBase)ESNumber.create(end - start));
        return array;
    }

    ESBase splice(Call eval, int length) throws Throwable {
        ESBase temp;
        int i;
        ESBase value;
        if (length < 2) {
            return esUndefined;
        }
        ESObject obj = eval.getArg(-1).toObject();
        int index = eval.getArg(0).toInt32();
        int count = eval.getArg(1).toInt32();
        boolean single = count == 1;
        ESBase lenObj = obj.getProperty(LENGTH);
        int len = lenObj.toInt32();
        if (index < 0) {
            index += len;
        }
        if (index < 0) {
            index = 0;
        }
        if (count < 0) {
            count = 0;
        }
        if (index + count > len) {
            count = len - index;
        }
        if (count < 1) {
            value = esUndefined;
        } else {
            value = Global.getGlobalProto().createArray();
            for (int i2 = 0; i2 < count; ++i2) {
                value.setProperty(i2, obj.getProperty(index + i2));
            }
        }
        int delta = length - 2 - count;
        if (delta < 0) {
            for (i = 0; i < len - count; ++i) {
                temp = obj.getProperty(i + index + count);
                if (temp == null) {
                    obj.delete(ESString.create(i + index + count + delta));
                    continue;
                }
                obj.setProperty(i + index + count + delta, temp);
            }
        } else if (delta > 0) {
            for (i = len - count - 1; i >= 0; --i) {
                temp = obj.getProperty(i + index + count);
                if (temp == null) {
                    obj.delete(ESString.create(i + index + count + delta));
                    continue;
                }
                obj.setProperty(i + index + count + delta, temp);
            }
        }
        for (i = 0; i < length - 2; ++i) {
            obj.setProperty(i + index, eval.getArg(i + 2));
        }
        obj.setProperty(LENGTH, (ESBase)ESNumber.create(len - count + length - 2));
        return value;
    }
}

