/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.rc.retroweaver.runtime.ClassLiteral;

public class ESString
extends ESBase {
    static ESId NULL;
    static ESId LENGTH;
    private static ESId[] ints;
    protected String string;
    protected int hashCode;

    protected ESString(String string) {
        if (ints == null) {
            ints = new ESId[128];
            NULL = ESId.intern("");
            LENGTH = ESId.intern("length");
            for (int i = 0; i < ints.length; ++i) {
                ESString.ints[i] = ESId.intern(String.valueOf(i));
            }
        }
        this.prototype = esNull;
        this.string = string;
    }

    public static ESString create(String string) {
        return string == null ? NULL : new ESString(string);
    }

    public static ESBase toStr(String string) {
        return string == null ? esNull : new ESString(string);
    }

    public static ESString create(int i) {
        if (i >= 0 && i < ints.length) {
            return ints[i];
        }
        return new ESString(String.valueOf(i));
    }

    public static ESString createFromCharCode(char c) {
        return new ESString(String.valueOf(c));
    }

    public static ESString create(CharBuffer cb) {
        return new ESString(cb.toString());
    }

    public static ESString create(Object obj) {
        return new ESString(String.valueOf(obj));
    }

    public ESBase typeof() throws ESException {
        return ESString.create("string");
    }

    public Class getJavaType() {
        return ClassLiteral.getClass((String)"java/lang/String");
    }

    public double toNum() {
        return ESString.parseFloat(this, true);
    }

    public ESString toStr() {
        return this;
    }

    public boolean isString() {
        return true;
    }

    public ESString toSource(IntMap map, boolean isLoopPass) {
        if (isLoopPass) {
            return null;
        }
        return ESString.create("\"" + this.string + "\"");
    }

    public ESObject toObject() {
        ESWrapper obj = new ESWrapper("String", (ESBase)Global.getGlobalProto().stringProto, this);
        obj.put(LENGTH, (ESBase)ESNumber.create(this.string.length()), 7);
        return obj;
    }

    public Object toJavaObject() {
        return this.string;
    }

    public ESBase getProperty(ESString key) throws Throwable {
        if (key.equals(LENGTH)) {
            return ESNumber.create(this.string.length());
        }
        return Global.getGlobalProto().stringProto.getProperty(key);
    }

    public boolean ecmaEquals(ESBase b) throws Throwable {
        if (b == esNull) {
            return false;
        }
        if (b instanceof ESString) {
            return this.string.equals(((ESString)b).string);
        }
        if (b instanceof ESObject) {
            ESBase pb = b.toPrimitive(0);
            if (pb instanceof ESString) {
                return this.equals(pb);
            }
            return this.toNum() == pb.toNum();
        }
        return this.toNum() == b.toNum();
    }

    public ESBase plus(ESBase b) throws Throwable {
        ESBase prim = b.toPrimitive(0);
        return ESString.create(this.string + prim.toStr().toString());
    }

    char charAt(int i) {
        return this.string.charAt(i);
    }

    public char carefulCharAt(int i) {
        if (i >= this.string.length()) {
            return '\uffff';
        }
        return this.string.charAt(i);
    }

    int length() {
        return this.string.length();
    }

    boolean regionMatches(int i, String test, int j, int len) {
        return this.string.regionMatches(i, test, j, len);
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash != 0) {
            return hash;
        }
        hash = 1021;
        int len = this.string.length();
        for (int i = 0; i < len; ++i) {
            hash = 65521 * hash + (this.string.charAt(i) + '\u0001') * 251;
        }
        this.hashCode = hash;
        return hash;
    }

    public boolean equals(Object a) {
        if (this == a) {
            return true;
        }
        if (a instanceof ESString) {
            return this.string.equals(((ESString)a).string);
        }
        return false;
    }

    int compareTo(ESString b) {
        return this.string.compareTo(b.string);
    }

    int indexOf(ESString a, int pos) {
        return this.string.indexOf(a.string, pos);
    }

    int lastIndexOf(ESString a, int pos) {
        return this.string.lastIndexOf(a.string, pos);
    }

    ESString substring(int begin, int end) {
        return ESString.create(this.string.substring(begin, end));
    }

    ESString substring(int begin) {
        return this.substring(begin, this.string.length());
    }

    ESString toLowerCase() {
        return ESString.create(this.string.toLowerCase());
    }

    ESString toUpperCase() {
        return ESString.create(this.string.toUpperCase());
    }

    ESBoolean contains(ESBase b) throws Throwable {
        ESString sb = b.toStr();
        if (sb.string.length() == 0) {
            return ESBoolean.TRUE;
        }
        int len = this.string.length();
        for (int i = 0; i <= len; ++i) {
            if (!this.string.regionMatches(i, sb.string, 0, sb.length())) continue;
            return ESBoolean.TRUE;
        }
        return ESBoolean.FALSE;
    }

    ESBoolean startsWith(ESBase b) throws Throwable {
        ESString sb = b.toStr();
        return ESBoolean.create(this.string.startsWith(sb.string));
    }

    ESBoolean endsWith(ESBase b) throws Throwable {
        ESString sb = b.toStr();
        return ESBoolean.create(this.string.endsWith(sb.string));
    }

    public boolean toBoolean() {
        return this.string.length() != 0;
    }

    static boolean isWhitespace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static double checkTail(double value, ESString string, int i) {
        while (i < string.length()) {
            if (!ESString.isWhitespace(string.charAt(i))) {
                return Double.NaN;
            }
            ++i;
        }
        return value;
    }

    static double parseFloat(ESString string, boolean hexOkay) {
        int i;
        int len = string.length();
        char ch = '\u0000';
        for (i = 0; i < len && ESString.isWhitespace(string.charAt(i)); ++i) {
        }
        if (i >= len) {
            return hexOkay ? 0.0 : Double.NaN;
        }
        int radix = 10;
        if (hexOkay && i + 1 < len && (ch = string.charAt(i)) == '0' && ((ch = string.charAt(i + 1)) == 'x' || ch == 'X')) {
            i += 2;
            radix = 16;
        }
        int sign = 1;
        if (radix == 10 && i < len && (ch = string.charAt(i)) == '+') {
            ++i;
        } else if (radix == 10 && i < len && ch == '-') {
            sign = -1;
            ++i;
        }
        if (radix == 10 && string.regionMatches(i, "Infinity", 0, 8)) {
            if (hexOkay) {
                return ESString.checkTail((double)sign * Double.POSITIVE_INFINITY, string, i + 8);
            }
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        double value = 0.0;
        boolean hasDigit = false;
        while (i < len) {
            ch = string.charAt(i);
            if ('0' <= ch && ch <= '9') {
                value = (double)radix * value + (double)string.charAt(i) - 48.0;
                hasDigit = true;
            } else if (radix > 10 && 'a' <= ch && ch <= 97 + radix - 11) {
                value = (double)radix * value + (double)string.charAt(i) - 97.0 + 10.0;
                hasDigit = true;
            } else {
                if (radix <= 10 || 'A' > ch || ch > 65 + radix - 11) break;
                value = (double)radix * value + (double)string.charAt(i) - 65.0 + 10.0;
                hasDigit = true;
            }
            ++i;
        }
        if (radix == 16 && !hasDigit) {
            return Double.NaN;
        }
        if (radix == 16) {
            return ESString.checkTail(value, string, i);
        }
        int expt = 0;
        if (i < len && string.charAt(i) == '.') {
            ++i;
            int power = 1;
            while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                if (ch == '0') {
                    ++power;
                } else {
                    value = value * Math.pow(10.0, power) + (double)ch - 48.0;
                    expt -= power;
                    power = 1;
                }
                hasDigit = true;
                ++i;
            }
        }
        if (!hasDigit) {
            return Double.NaN;
        }
        if (i < len && ((ch = string.charAt(i)) == 'e' || ch == 'E')) {
            int exptSign = 1;
            if (++i < len && (ch = string.charAt(i)) == '+') {
                ++i;
            } else if (i < len && ch == '-') {
                exptSign = -1;
                ++i;
            }
            hasDigit = false;
            int newExpt = 0;
            while (i < len && (ch = string.charAt(i)) >= '0' && ch <= '9') {
                newExpt = 10 * newExpt + ch - 48;
                hasDigit = true;
                ++i;
            }
            if (!hasDigit) {
                return Double.NaN;
            }
            expt += exptSign * newExpt;
        }
        value = expt < 0 ? (double)sign * value / Math.pow(10.0, -expt) : (double)sign * value * Math.pow(10.0, expt);
        if (hexOkay) {
            return ESString.checkTail(value, string, i);
        }
        return value;
    }

    static double parseFloat(ESString string) {
        return ESString.parseFloat(string, false);
    }

    public String toString() {
        return this.string;
    }
}

