/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESArrayWrap;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESJavaWrapper;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;

public class ESArrayWrapper {
    public static ESJavaWrapper wrapper(Global g, Class cl) {
        Class<?> baseClass = cl.getComponentType();
        String name = baseClass.getName();
        if (name.equals("boolean")) {
            return new BooleanArray(g);
        }
        if (name.equals("byte")) {
            return new ByteArray(g);
        }
        if (name.equals("short")) {
            return new ShortArray(g);
        }
        if (name.equals("char")) {
            return new CharArray(g);
        }
        if (name.equals("int")) {
            return new IntArray(g);
        }
        if (name.equals("long")) {
            return new LongArray(g);
        }
        if (name.equals("float")) {
            return new FloatArray(g);
        }
        if (name.equals("double")) {
            return new DoubleArray(g);
        }
        return new ObjArray(g);
    }

    static class DoubleArray
    extends ESArrayWrap {
        protected DoubleArray() {
        }

        protected ESObject dup() {
            DoubleArray dup = new DoubleArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((double[])this.value).length;
        }

        public ESBase getProperty(int i) {
            double[] array = (double[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            double[] array = (double[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = value.toNum();
            }
        }

        public ESBase delete(int i) throws ESException {
            double[] array = (double[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0.0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        DoubleArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class FloatArray
    extends ESArrayWrap {
        protected FloatArray() {
        }

        protected ESObject dup() {
            FloatArray dup = new FloatArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((float[])this.value).length;
        }

        public ESBase getProperty(int i) {
            float[] array = (float[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            float[] array = (float[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = (float)value.toNum();
            }
        }

        public ESBase delete(int i) throws ESException {
            float[] array = (float[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0.0f;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        FloatArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class LongArray
    extends ESArrayWrap {
        protected LongArray() {
        }

        protected ESObject dup() {
            LongArray dup = new LongArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((long[])this.value).length;
        }

        public ESBase getProperty(int i) {
            long[] array = (long[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            long[] array = (long[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = (long)value.toNum();
            }
        }

        public ESBase delete(int i) throws ESException {
            long[] array = (long[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0L;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        LongArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class IntArray
    extends ESArrayWrap {
        protected IntArray() {
        }

        protected ESObject dup() {
            IntArray dup = new IntArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((int[])this.value).length;
        }

        public ESBase getProperty(int i) {
            int[] array = (int[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            int[] array = (int[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = value.toInt32();
            }
        }

        public ESBase delete(int i) throws ESException {
            int[] array = (int[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        IntArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class CharArray
    extends ESArrayWrap {
        protected CharArray() {
        }

        protected ESObject dup() {
            CharArray dup = new CharArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((char[])this.value).length;
        }

        public ESBase getProperty(int i) {
            char[] array = (char[])this.value;
            if (i >= 0 && i < array.length) {
                return ESString.create("" + array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            char[] array = (char[])this.value;
            if (i >= 0 && i < array.length) {
                ESString str = value.toStr();
                array[i] = str.length() > 0 ? str.charAt(0) : (char)'\u0000';
            }
        }

        public ESBase delete(int i) throws ESException {
            char[] array = (char[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = '\u0000';
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        CharArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class ShortArray
    extends ESArrayWrap {
        protected ShortArray() {
        }

        protected ESObject dup() {
            ShortArray dup = new ShortArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((short[])this.value).length;
        }

        public ESBase getProperty(int i) {
            short[] array = (short[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            short[] array = (short[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = (short)value.toInt32();
            }
        }

        public ESBase delete(int i) throws ESException {
            short[] array = (short[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        ShortArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class ByteArray
    extends ESArrayWrap {
        protected ByteArray() {
        }

        protected ESObject dup() {
            ByteArray dup = new ByteArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((byte[])this.value).length;
        }

        public ESBase getProperty(int i) {
            byte[] array = (byte[])this.value;
            if (i >= 0 && i < array.length) {
                return ESNumber.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws Throwable {
            byte[] array = (byte[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = (byte)value.toInt32();
            }
        }

        public ESBase delete(int i) throws ESException {
            byte[] array = (byte[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = 0;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        ByteArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class BooleanArray
    extends ESArrayWrap {
        protected BooleanArray() {
        }

        protected ESObject dup() {
            BooleanArray dup = new BooleanArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((boolean[])this.value).length;
        }

        public ESBase getProperty(int i) {
            boolean[] array = (boolean[])this.value;
            if (i >= 0 && i < array.length) {
                return ESBoolean.create(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws ESException {
            boolean[] array = (boolean[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = value.toBoolean();
            }
        }

        public ESBase delete(int i) throws ESException {
            boolean[] array = (boolean[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = false;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        BooleanArray(Global g) {
            super(g.arrayProto, null);
        }
    }

    static class ObjArray
    extends ESArrayWrap {
        protected ObjArray() {
        }

        protected ESObject dup() {
            ObjArray dup = new ObjArray();
            dup.value = this.value;
            return dup;
        }

        protected int length() {
            return ((Object[])this.value).length;
        }

        public ESBase getProperty(int i) throws Throwable {
            Object[] array = (Object[])this.value;
            if (i >= 0 && i < array.length) {
                Global.getGlobalProto();
                return Global.wrap(array[i]);
            }
            return esEmpty;
        }

        public void setProperty(int i, ESBase value) throws ESException {
            Object[] array = (Object[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = value.toJavaObject();
            }
        }

        public ESBase delete(int i) throws ESException {
            Object[] array = (Object[])this.value;
            if (i >= 0 && i < array.length) {
                array[i] = null;
                return ESBoolean.TRUE;
            }
            return ESBoolean.FALSE;
        }

        ObjArray(Global g) {
            super(g.arrayProto, null);
        }
    }
}

