/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESArray;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.util.IntMap;
import java.util.HashMap;

class ESArguments
extends ESObject {
    static ESId CALLEE = ESId.intern("callee");
    static ESId ARGUMENTS = ESId.intern("arguments");
    static ESId LENGTH = ESId.intern("length");
    HashMap aliases = new HashMap();

    private ESArguments(ESId[] formals, Call eval, int length) throws ESException {
        super("Arguments", Global.getGlobalProto().arrayProto);
        int i;
        for (i = 0; i < length; ++i) {
            super.put(ESString.create(i), eval.getArg(i, length), 4);
        }
        for (i = 0; i < formals.length; ++i) {
            super.put(formals[i], eval.getArg(i, length), 6);
            this.aliases.put(formals[i], ESString.create(i));
            this.aliases.put(ESString.create(i), formals[i]);
        }
        super.put(LENGTH, (ESBase)ESNumber.create(length), 4);
        super.put(CALLEE, eval.callee, 4);
    }

    static ESObject create(ESId[] formals, Call eval, int length) throws ESException {
        ESArguments args = new ESArguments(formals, eval, length);
        args.put(ARGUMENTS, (ESBase)args, 6);
        return args;
    }

    public ESString toSource(IntMap map, boolean isLoopPass) throws Throwable {
        return ESArray.arrayToSource(this, map, isLoopPass);
    }

    public void setProperty(ESString key, ESBase value) throws Throwable {
        ESId alias = (ESId)this.aliases.get(key);
        super.setProperty(key, value);
        if (alias != null) {
            super.setProperty(alias, value);
        }
    }

    public void put(ESString key, ESBase value, int flags) {
        ESId alias = (ESId)this.aliases.get(key);
        super.put(key, value, flags);
        if (alias != null) {
            super.put(alias, value, flags);
        }
    }

    public ESBase delete(ESString key) throws Throwable {
        ESId alias = (ESId)this.aliases.get(key);
        if (alias == null) {
            return super.delete(key);
        }
        return ESBoolean.FALSE;
    }

    protected ESArguments() {
    }

    protected ESObject dup() {
        return new ESArguments();
    }

    protected void copy(HashMap refs, Object newObj) {
        ESArguments newArgs = (ESArguments)newObj;
        newArgs.aliases = this.aliases;
        super.copy(refs, newObj);
    }
}

