/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class EqExpr
extends AbstractBooleanExpr {
    private int _op;
    private Expr _left;
    private Expr _right;

    public EqExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    public boolean isConstant() {
        return this._left.isConstant() && this._right.isConstant();
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        Object bObj;
        Object aObj = this._left.evalObject(env);
        if (aObj == (bObj = this._right.evalObject(env))) {
            return this._op == 6;
        }
        if (aObj == null || bObj == null) {
            return this._op == 7;
        }
        if (aObj.equals(bObj)) {
            return this._op == 6;
        }
        try {
            if (aObj instanceof Double || aObj instanceof Float || bObj instanceof Double || bObj instanceof Float) {
                double a = EqExpr.toDouble(aObj, env);
                double b = EqExpr.toDouble(bObj, env);
                switch (this._op) {
                    case 6: {
                        return a == b;
                    }
                    case 7: {
                        return a != b;
                    }
                }
            }
            if (aObj instanceof Number || bObj instanceof Number) {
                long a = EqExpr.toLong(aObj, env);
                long b = EqExpr.toLong(bObj, env);
                switch (this._op) {
                    case 6: {
                        return a == b;
                    }
                    case 7: {
                        return a != b;
                    }
                }
            }
            if (aObj instanceof Boolean || bObj instanceof Boolean) {
                boolean a = EqExpr.toBoolean(aObj, env);
                boolean b = EqExpr.toBoolean(bObj, env);
                switch (this._op) {
                    case 6: {
                        return a == b;
                    }
                    case 7: {
                        return a != b;
                    }
                }
            }
            if (aObj instanceof String || bObj instanceof String) {
                String a = EqExpr.toString(aObj, env);
                String b = EqExpr.toString(bObj, env);
                switch (this._op) {
                    case 6: {
                        return a.equals(b);
                    }
                    case 7: {
                        return !a.equals(b);
                    }
                }
            }
        }
        catch (ELException e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.EqExpr(");
        os.print(this._op + ", ");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof EqExpr)) {
            return false;
        }
        EqExpr expr = (EqExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 6: {
                op = " eq ";
                break;
            }
            case 7: {
                op = " ne ";
                break;
            }
            default: {
                op = " unknown(" + this._op + ") ";
            }
        }
        return "(" + this._left + op + this._right + ")";
    }
}

