/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.BinaryExpr;
import com.caucho.el.BooleanExpr;
import com.caucho.el.BooleanLiteral;
import com.caucho.el.CmpExpr;
import com.caucho.el.ConditionalExpr;
import com.caucho.el.DoubleLiteral;
import com.caucho.el.ELParseException;
import com.caucho.el.EqExpr;
import com.caucho.el.Expr;
import com.caucho.el.IdExpr;
import com.caucho.el.InterpolateExpr;
import com.caucho.el.LongLiteral;
import com.caucho.el.NullLiteral;
import com.caucho.el.StaticMethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.el.UnaryExpr;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELParser {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/el/ELParser"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/el/ELParser"));
    private String _string;
    private int _index;
    private int _peek = -1;
    private String _lexeme;
    private CharBuffer _cb = CharBuffer.allocate();
    private Map<String, Method> _staticFunctionMap;
    private boolean _checkEscape;

    public ELParser(String string) {
        this._string = string;
    }

    protected ELParser create(String string) {
        ELParser parser = new ELParser(string);
        parser.copy(this);
        return parser;
    }

    protected void copy(ELParser parser) {
        parser._staticFunctionMap = this._staticFunctionMap;
    }

    public void setStaticFunctionMap(Map<String, Method> map) {
        this._staticFunctionMap = map;
    }

    public void setCheckEscape(boolean checkEscape) {
        this._checkEscape = checkEscape;
    }

    public Expr parse() throws ELParseException {
        return this.parseInterpolate();
    }

    public Expr parseInterpolate() throws ELParseException {
        Expr right;
        int ch;
        CharBuffer text = CharBuffer.allocate();
        CharBuffer exprString = CharBuffer.allocate();
        Expr expr = null;
        while ((ch = this.read()) >= 0) {
            if (this._checkEscape && ch == 92) {
                ch = this.read();
                if (ch == 36 || ch == 92) {
                    text.append((char)ch);
                    continue;
                }
                text.append('\\');
                this.unread();
                continue;
            }
            if (ch == 36) {
                ch = this.read();
                if (ch == 123) {
                    if (text.length() > 0) {
                        right = new StringLiteral(text.toString());
                        expr = expr == null ? right : new InterpolateExpr(expr, right);
                        text.clear();
                    }
                    exprString.clear();
                    ch = this.read();
                    while (ch > 0 && ch != 125) {
                        exprString.append((char)ch);
                        ch = this.read();
                    }
                    if (ch != 125) {
                        throw this.error(L.l("expected '}' at end of EL expression", exprString));
                    }
                    right = this.create(exprString.toString()).parseExpr();
                    if (expr == null) {
                        expr = right;
                        continue;
                    }
                    expr = new InterpolateExpr(expr, right);
                    continue;
                }
                text.append('$');
                this.unread();
                continue;
            }
            text.append((char)ch);
        }
        if (text.length() > 0) {
            right = new StringLiteral(text.toString());
            expr = expr == null ? right : new InterpolateExpr(expr, right);
        }
        if (expr == null) {
            expr = new StringLiteral("");
        }
        return expr;
    }

    private Expr parseExpr() throws ELParseException {
        int token;
        Expr left = this.parseTerm();
        block8: while (true) {
            token = this.scanToken();
            switch (token) {
                case 63: {
                    Expr trueExpr = this.parseExpr();
                    token = this.scanToken();
                    if (token != 58) {
                        throw this.error(L.l("Expected `:' at {0}.  Conditional syntax is 'expr ? expr : expr'.", this.badChar(token)));
                    }
                    Expr falseExpr = this.parseExpr();
                    left = new ConditionalExpr(left, trueExpr, falseExpr);
                    continue block8;
                }
                case 13: {
                    left = this.parseOrExpr(token, left, this.parseTerm());
                    continue block8;
                }
                case 12: {
                    left = this.parseAndExpr(token, left, this.parseTerm());
                    continue block8;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    left = this.parseCmpExpr(token, left, this.parseTerm());
                    continue block8;
                }
                case 1: 
                case 2: {
                    left = this.parseAddExpr(token, left, this.parseTerm());
                    continue block8;
                }
                case 3: 
                case 4: 
                case 5: {
                    left = this.parseMulExpr(token, left, this.parseTerm());
                    continue block8;
                }
            }
            break;
        }
        this._peek = token;
        return left;
    }

    private Expr parseOrExpr(int code, Expr left, Expr right) throws ELParseException {
        int token;
        block7: while (true) {
            token = this.scanToken();
            switch (token) {
                case 13: {
                    left = new BooleanExpr(code, left, right);
                    code = token;
                    right = this.parseTerm();
                    continue block7;
                }
                case 12: {
                    right = this.parseAndExpr(token, right, this.parseTerm());
                    continue block7;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    right = this.parseCmpExpr(token, right, this.parseTerm());
                    continue block7;
                }
                case 1: 
                case 2: {
                    right = this.parseAddExpr(token, right, this.parseTerm());
                    continue block7;
                }
                case 3: 
                case 4: 
                case 5: {
                    right = this.parseMulExpr(token, right, this.parseTerm());
                    continue block7;
                }
            }
            break;
        }
        this._peek = token;
        return new BooleanExpr(code, left, right);
    }

    private Expr parseAndExpr(int code, Expr left, Expr right) throws ELParseException {
        int token;
        block6: while (true) {
            token = this.scanToken();
            switch (token) {
                case 12: {
                    left = new BooleanExpr(code, left, right);
                    code = token;
                    right = this.parseTerm();
                    continue block6;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    right = this.parseCmpExpr(token, right, this.parseTerm());
                    continue block6;
                }
                case 1: 
                case 2: {
                    right = this.parseAddExpr(token, right, this.parseTerm());
                    continue block6;
                }
                case 3: 
                case 4: 
                case 5: {
                    right = this.parseMulExpr(token, right, this.parseTerm());
                    continue block6;
                }
            }
            break;
        }
        this._peek = token;
        return new BooleanExpr(code, left, right);
    }

    private Expr parseCmpExpr(int code, Expr left, Expr right) throws ELParseException {
        int token;
        block5: while (true) {
            token = this.scanToken();
            switch (token) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    left = code == 6 || code == 7 ? new EqExpr(code, left, right) : new CmpExpr(code, left, right);
                    code = token;
                    right = this.parseTerm();
                    continue block5;
                }
                case 1: 
                case 2: {
                    right = this.parseAddExpr(token, right, this.parseTerm());
                    continue block5;
                }
                case 3: 
                case 4: 
                case 5: {
                    right = this.parseMulExpr(token, right, this.parseTerm());
                    continue block5;
                }
            }
            break;
        }
        this._peek = token;
        if (code == 6 || code == 7) {
            return new EqExpr(code, left, right);
        }
        return new CmpExpr(code, left, right);
    }

    private Expr parseAddExpr(int code, Expr left, Expr right) throws ELParseException {
        int token;
        block4: while (true) {
            token = this.scanToken();
            switch (token) {
                case 1: 
                case 2: {
                    left = new BinaryExpr(code, left, right);
                    code = token;
                    right = this.parseTerm();
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    right = this.parseMulExpr(token, right, this.parseTerm());
                    continue block4;
                }
            }
            break;
        }
        this._peek = token;
        return new BinaryExpr(code, left, right);
    }

    private Expr parseMulExpr(int code, Expr left, Expr right) throws ELParseException {
        int token;
        block3: while (true) {
            token = this.scanToken();
            switch (token) {
                case 3: 
                case 4: 
                case 5: {
                    left = new BinaryExpr(code, left, right);
                    right = this.parseTerm();
                    code = token;
                    continue block3;
                }
            }
            break;
        }
        this._peek = token;
        return new BinaryExpr(code, left, right);
    }

    private Expr parseTerm() throws ELParseException {
        int token;
        Expr term = this.parseSimpleTerm();
        block5: while (true) {
            token = this.scanToken();
            switch (token) {
                case 91: {
                    Expr expr = this.parseExpr();
                    token = this.scanToken();
                    if (token != 93) {
                        throw this.error(L.l("Expected `]' at {0}.  All open array braces must have matching closing brace.", this.badChar(token)));
                    }
                    term = term.createField(expr);
                    continue block5;
                }
                case 40: {
                    ArrayList<Expr> argList = new ArrayList<Expr>();
                    int ch = this.skipWhitespace(this.read());
                    while (ch > 0 && ch != 41) {
                        this.unread();
                        argList.add(this.parseExpr());
                        token = this.scanToken();
                        if (token != 44) {
                            ch = token;
                            break;
                        }
                        ch = this.skipWhitespace(this.read());
                    }
                    if (ch != 41) {
                        throw this.error(L.l("Expected `)' at {0}.  All functions must have matching closing parenthesis.", this.badChar(ch)));
                    }
                    Expr[] args = argList.toArray(new Expr[argList.size()]);
                    Expr expr = term.createMethod(args);
                    if (expr == null) {
                        throw this.error(L.l("Method call not supported in this context `{0}'.", term));
                    }
                    term = expr;
                    continue block5;
                }
                case 46: {
                    int ch = this.skipWhitespace(this.read());
                    if (!Character.isJavaIdentifierStart((char)ch)) {
                        throw this.error(L.l("Expected `]' at {0}.  Field references must be identifiers.", this.badChar(ch)));
                    }
                    String field = this.readName(ch);
                    term = term.createField(field);
                    continue block5;
                }
            }
            break;
        }
        this._peek = token;
        return term;
    }

    private Expr parseSimpleTerm() throws ELParseException {
        int ch = this.read();
        ch = this.skipWhitespace(ch);
        switch (ch) {
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                long value = 0L;
                double exp = 1.0;
                int digits = 0;
                while (ch >= 48 && ch <= 57) {
                    value = 10L * value + (long)ch - 48L;
                    ch = this.read();
                }
                if (ch != 46 && ch != 101 && ch != 69) {
                    this.unread();
                    return new LongLiteral(value);
                }
                if (ch == 46) {
                    ch = this.read();
                    while (ch >= 48 && ch <= 57) {
                        value = 10L * value + (long)ch - 48L;
                        exp *= 10.0;
                        --digits;
                        ch = this.read();
                    }
                }
                if (ch == 101 || ch == 69) {
                    int sign = 1;
                    int expValue = 0;
                    ch = this.read();
                    if (ch == 45) {
                        sign = -1;
                        ch = this.read();
                    } else if (ch == 43) {
                        ch = this.read();
                    }
                    while (ch >= 48 && ch <= 57) {
                        expValue = 10 * expValue + ch - 48;
                        ch = this.read();
                    }
                    exp = Math.pow(10.0, digits + sign * expValue);
                    this.unread();
                    return new DoubleLiteral((double)value * exp);
                }
                this.unread();
                return new DoubleLiteral((double)value / exp);
            }
            case 45: {
                return new UnaryExpr(15, this.parseTerm());
            }
            case 33: {
                return new UnaryExpr(14, this.parseTerm());
            }
            case 43: {
                return this.parseTerm();
            }
            case 40: {
                Expr expr = this.parseExpr();
                ch = this.scanToken();
                if (ch != 41) {
                    throw this.error(L.l("Expected `)' at {0}.  All open parentheses must have matching closing parentheses.", this.badChar(ch)));
                }
                return expr;
            }
            case 34: 
            case 39: {
                int end = ch;
                CharBuffer cb = new CharBuffer();
                ch = this.read();
                while (ch >= 0) {
                    if (ch == 92) {
                        cb.append((char)this.read());
                    } else if (ch != end) {
                        cb.append((char)ch);
                    } else {
                        ch = this.read();
                        if (ch == end) {
                            cb.append((char)ch);
                        } else {
                            this.unread();
                            break;
                        }
                    }
                    ch = this.read();
                }
                return new StringLiteral(cb.toString());
            }
        }
        if (!Character.isJavaIdentifierStart((char)ch) && ch != 58) {
            throw this.error(L.l("Unexpected character at {0}.", this.badChar(ch)));
        }
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch) || ch == 58) {
            cb.append((char)ch);
            ch = this.read();
        }
        this.unread();
        String name = cb.close();
        if (name.equals("null")) {
            return new NullLiteral();
        }
        if (name.equals("true")) {
            return new BooleanLiteral(true);
        }
        if (name.equals("false")) {
            return new BooleanLiteral(false);
        }
        if (name.equals("not")) {
            return new UnaryExpr(14, this.parseTerm());
        }
        if (name.equals("empty")) {
            return new UnaryExpr(16, this.parseTerm());
        }
        Expr expr = this.createImplicitObjectExpr(name);
        if (expr != null) {
            return expr;
        }
        Method method = this.getStaticMethod(name);
        if (method != null) {
            return new StaticMethodExpr(method);
        }
        return new IdExpr(name);
    }

    protected Expr createImplicitObjectExpr(String name) {
        return null;
    }

    protected Method getStaticMethod(String name) {
        if (this._staticFunctionMap != null) {
            return this._staticFunctionMap.get(name);
        }
        return null;
    }

    private int scanToken() throws ELParseException {
        if (this._peek >= 0) {
            int value = this._peek;
            this._peek = -1;
            return value;
        }
        int ch = this.skipWhitespace(this.read());
        switch (ch) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 47: {
                return 4;
            }
            case 37: {
                return 5;
            }
            case 33: {
                ch = this.read();
                if (ch == 61) {
                    return 7;
                }
                return 14;
            }
            case 61: {
                ch = this.read();
                if (ch == 61) {
                    return 6;
                }
                throw this.error(L.l("expected `{0}' at {1}", (Object)"=", this.badChar(ch)));
            }
            case 38: {
                ch = this.read();
                if (ch == 38) {
                    return 12;
                }
                throw this.error(L.l("expected `&&' at {0}", this.badChar(ch)));
            }
            case 124: {
                ch = this.read();
                if (ch == 124) {
                    return 13;
                }
                throw this.error(L.l("expected `||' at {0}", this.badChar(ch)));
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 9;
                }
                this.unread();
                return 8;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 11;
                }
                this.unread();
                return 10;
            }
            case 91: {
                return 91;
            }
            case 93: {
                return 93;
            }
            case 41: {
                return 41;
            }
            case 40: {
                return 40;
            }
            case 46: {
                return 46;
            }
            case 44: {
                return 44;
            }
            case 58: 
            case 63: {
                return ch;
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            String name = this.readName(ch);
            if (name.equals("div")) {
                return 4;
            }
            if (name.equals("mod")) {
                return 5;
            }
            if (name.equals("eq")) {
                return 6;
            }
            if (name.equals("ne")) {
                return 7;
            }
            if (name.equals("lt")) {
                return 8;
            }
            if (name.equals("le")) {
                return 9;
            }
            if (name.equals("gt")) {
                return 10;
            }
            if (name.equals("ge")) {
                return 11;
            }
            if (name.equals("and")) {
                return 12;
            }
            if (name.equals("or")) {
                return 13;
            }
            throw this.error(L.l("expected binary operation at `{0}'", name));
        }
        this.unread();
        return -1;
    }

    private String readName(int ch) {
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch)) {
            cb.append((char)ch);
            ch = this.read();
        }
        this.unread();
        return cb.toString();
    }

    private int skipWhitespace(int ch) throws ELParseException {
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this._index < this._string.length()) {
            return this._string.charAt(this._index++);
        }
        ++this._index;
        return -1;
    }

    private void unread() {
        --this._index;
    }

    private String badChar(int ch) {
        if (ch < 0) {
            return L.l("end of file");
        }
        if (ch == 10) {
            return L.l("end of line");
        }
        return new StringBuffer().append("`").append((char)ch).append("'").toString();
    }

    private ELParseException error(String message) {
        return new ELParseException(new StringBuffer().append(message).append(" in ").append(this._string).toString());
    }
}

