/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.field.IdField;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.CollectionExpr;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.FieldExpr;
import com.caucho.ejb.ql.RelationExpr;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PathExpr
extends Expr {
    protected EjbEntityBean _bean;

    abstract String getKeyTable();

    abstract String[] getKeyFields();

    abstract String getTable();

    PathExpr(EjbEntityBean bean) {
        this._bean = bean;
        this.setJavaType(bean.getEJBClass());
    }

    EjbEntityBean getBean() {
        return this._bean;
    }

    @Override
    Expr newField(String fieldName) throws ConfigException {
        CmpField field = this._bean.getCmpField(fieldName);
        if (field != null) {
            return new FieldExpr(this._query, this, fieldName, field);
        }
        CmrRelation relation = this._bean.getRelation(fieldName);
        if (relation == null) {
            throw this.error(L.l("{0}: `{1}' is an unknown cmp-field.", (Object)this._bean.getEJBClass().getName(), fieldName));
        }
        if (relation.isCollection()) {
            return new CollectionExpr(this._query, this, fieldName, relation);
        }
        return new RelationExpr(this._query, this, fieldName, relation);
    }

    @Override
    int getComponentCount() {
        return this.getKeyFields().length;
    }

    void setUsesField() {
    }

    protected String generateKeyField(EntityType type, int index) {
        ArrayList<String> names = this.generateKeyFields(type);
        return names.get(index);
    }

    protected ArrayList<String> generateKeyFields(EntityType type) {
        ArrayList<String> names = new ArrayList<String>();
        for (IdField key : type.getId().getKeys()) {
            String name = key.getName();
            if (key.getType() instanceof EntityType) {
                ArrayList<String> subNames = this.generateKeyFields((EntityType)key.getType());
                for (String subName : subNames) {
                    names.add(new StringBuffer().append(name).append('.').append(subName).toString());
                }
                continue;
            }
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    void generateAmber(CharBuffer cb) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

