/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class BinaryExpr
extends Expr {
    private int _op;
    private Expr _left;
    private Expr _right;

    BinaryExpr(Query query, int op, Expr left, Expr right) throws ConfigException {
        this._query = query;
        this._op = op;
        this._left = left;
        this._right = right;
        this.evalTypes();
    }

    Expr getLeft() {
        return this._left;
    }

    void evalTypes() throws ConfigException {
        switch (this._op) {
            case 155: 
            case 156: {
                if (!(this._left.getJavaType().equals(this._right.getJavaType()) || this._left.isNumeric() == this._right.isNumeric() || this._left.isDate() && this._right.isDate())) {
                    throw this.error(L.l("`{0}' has mismatched types `{1}' != `{2}'", this, this._left.getJavaType().getName(), this._right.getJavaType().getName()));
                }
                this.setJavaType(Boolean.TYPE);
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                if (!this._left.isDate() || !this._right.isDate()) {
                    if (!this._left.isNumeric()) {
                        throw this.error(L.l("`{0}' expects a numeric value at {1}.  Less-than and greater-than comparisons only make sense with numbers and dates.", (Object)this, this._left.getJavaType().getName()));
                    }
                    if (!this._right.isNumeric()) {
                        throw this.error(L.l("`{0}' expects a numeric value at {1}.  Less-than and greater-than comparisons only make sense with numbers and dates.", (Object)this, this._right.getJavaType().getName()));
                    }
                }
                this.setJavaType(Boolean.TYPE);
                break;
            }
            case 161: 
            case 162: {
                if (!this._left.isBoolean()) {
                    throw this.error(L.l("`{0}' expects a boolean value at {1}", (Object)this._left, this._left.getJavaType().getName()));
                }
                if (!this._right.isBoolean()) {
                    throw this.error(L.l("`{0}' expects a boolean value at {1}", (Object)this._right, this._right.getJavaType().getName()));
                }
                this.setJavaType(Boolean.TYPE);
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                if (!this._left.isNumeric()) {
                    throw this.error(L.l("`{0}' expects a numeric value at {1}", (Object)this._left, this._left.getJavaType().getName()));
                }
                if (!this._right.isNumeric()) {
                    throw this.error(L.l("`{0}' expects a numeric value at {1}", (Object)this._right, this._right.getJavaType().getName()));
                }
                if (Integer.TYPE.isAssignableFrom(this._left.getJavaType()) && Integer.TYPE.isAssignableFrom(this._right.getJavaType())) {
                    this.setJavaType(Integer.TYPE);
                    break;
                }
                if (Long.TYPE.isAssignableFrom(this._left.getJavaType()) && Long.TYPE.isAssignableFrom(this._right.getJavaType())) {
                    this.setJavaType(Long.TYPE);
                    break;
                }
                this.setJavaType(Double.TYPE);
                break;
            }
            default: {
                throw new RuntimeException("unknown binary op:" + this._op + " " + (char)this._op);
            }
        }
    }

    void generateWhere(CharBuffer cb) {
        if (this._left.isKey()) {
            int componentCount = this._left.getComponentCount();
            this.generateWhereComponents(cb, componentCount);
            return;
        }
        if (this._right.isKey()) {
            int componentCount = this._right.getComponentCount();
            this.generateWhereComponents(cb, componentCount);
            return;
        }
        this._left.generateComponent(cb, 0);
        switch (this._op) {
            case 155: {
                cb.append(" = ");
                break;
            }
            case 156: {
                cb.append(" <> ");
                break;
            }
            case 157: {
                cb.append(" < ");
                break;
            }
            case 159: {
                cb.append(" > ");
                break;
            }
            case 158: {
                cb.append(" <= ");
                break;
            }
            case 160: {
                cb.append(" >= ");
                break;
            }
            case 161: {
                cb.append(" AND ");
                break;
            }
            case 162: {
                cb.append(" OR ");
                break;
            }
            default: {
                cb.append(" " + (char)this._op + " ");
            }
        }
        this._right.generateComponent(cb, 0);
    }

    private void generateWhereComponents(CharBuffer cb, int componentCount) {
        for (int i = 0; i < componentCount; ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            this._left.generateComponent(cb, i);
            if (this._op == 155) {
                cb.append(" = ");
            } else if (this._op == 156) {
                cb.append(" <> ");
            }
            this._right.generateComponent(cb, i);
        }
    }

    void generateWhereSubExpr(CharBuffer cb) {
        cb.append("(");
        this.generateWhere(cb);
        cb.append(")");
    }

    void generateSelect(CharBuffer cb) {
        cb.append("(");
        this.generateWhere(cb);
        cb.append(")");
    }

    public String toString() {
        CharBuffer value = CharBuffer.allocate();
        if (this._left instanceof BinaryExpr) {
            value.append("(");
            value.append(this._left.toString());
            value.append(")");
        } else {
            value.append(this._left.toString());
        }
        switch (this._op) {
            case 155: {
                value.append(" = ");
                break;
            }
            case 156: {
                value.append(" <> ");
                break;
            }
            case 157: {
                value.append(" < ");
                break;
            }
            case 159: {
                value.append(" > ");
                break;
            }
            case 158: {
                value.append(" <= ");
                break;
            }
            case 160: {
                value.append(" >= ");
                break;
            }
            case 161: {
                value.append(" AND ");
                break;
            }
            case 162: {
                value.append(" OR ");
                break;
            }
            default: {
                value.append(" " + (char)this._op + " ");
            }
        }
        if (this._right instanceof BinaryExpr) {
            value.append("(");
            value.append(this._right.toString());
            value.append(")");
        } else {
            value.append(this._right.toString());
        }
        return value.close();
    }
}

