/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class ArgExpr
extends Expr {
    private int _index;
    private Class _coerceType;

    ArgExpr(Query query, int index) throws ConfigException {
        this._query = query;
        this._index = index;
        this.evalTypes();
    }

    int getIndex() {
        return this._query.getArgIndex(this._index);
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        Method method = this._query.getMethod();
        Class<?>[] args = method.getParameterTypes();
        if (args.length <= this._index - 1) {
            throw this.error(L.l("`{0}' exceeds number of arguments", "?" + this._index));
        }
        this.setJavaType(args[this._index - 1]);
        this._query.setArgSize(this._index, this.getComponentCount());
    }

    void setCoerceType(Class javaType) {
        this._coerceType = javaType;
    }

    boolean canCoerce() {
        return true;
    }

    int getComponentCount() {
        Class javaType = this.getJavaType();
        if (javaType.isPrimitive() || javaType.isArray() || javaType.getName().startsWith("java.")) {
            return 1;
        }
        if (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(javaType)) {
            EjbEntityBean bean = this._query.getConfig().findEntityByLocal(javaType);
            EntityType type = bean.getEntityType();
            return type.getId().getKeys().size();
        }
        Field[] fields = javaType.getFields();
        return fields.length;
    }

    void generateWhere(CharBuffer cb) {
        cb.append("?" + this.getIndex());
    }

    void generateComponent(CharBuffer cb, int index) {
        cb.append("?" + (this.getIndex() + index));
    }

    public String toString() {
        return "?" + this._index;
    }
}

