/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.RemoteExceptionWrapper;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.rmi.RemoteException;

public class SelfSerializer {
    TempStream trs;
    ReadStream is;
    WriteStream os;
    ObjectInputStream ois;
    ObjectOutputStream oos;

    public static SelfSerializer allocate() throws RemoteException {
        SelfSerializer ser = new SelfSerializer();
        ser.clear();
        return ser;
    }

    public void clear() throws RemoteException {
        try {
            this.trs = new TempStream(null);
            this.os = new WriteStream(this.trs);
            this.oos = new ObjectOutputStream(this.os);
            this.is = null;
            this.ois = null;
        }
        catch (Exception e) {
            throw new RemoteExceptionWrapper(e);
        }
    }

    public void write(Object obj) throws RemoteException {
        try {
            this.oos.writeObject(obj);
        }
        catch (Exception e) {
            throw new RemoteExceptionWrapper(e);
        }
    }

    public Object read() throws RemoteException {
        try {
            if (this.is == null) {
                this.oos.flush();
                this.is = this.trs.openRead(true);
                this.ois = new LoaderObjectInputStream(this.is);
            }
            return this.ois.readObject();
        }
        catch (Exception e) {
            throw new RemoteExceptionWrapper(e);
        }
    }

    public void close() {
        try {
            ReadStream is = this.is;
            this.is = null;
            WriteStream os = this.os;
            this.os = null;
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class LoaderObjectInputStream
    extends ObjectInputStream {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();

        LoaderObjectInputStream(InputStream is) throws IOException, StreamCorruptedException {
            super(is);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return CauchoSystem.loadClass(v.getName(), false, this.loader);
        }
    }
}

