/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.RemoteExceptionWrapper;
import com.caucho.ejb.gen.JVMHomeStubGenerator;
import com.caucho.ejb.gen.JVMObjectStubGenerator;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.JVMHome;
import com.caucho.ejb.protocol.JVMObject;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;

public class SameJVMClientContainer {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/protocol/SameJVMClientContainer"));
    private static final EnvironmentLocal<Hashtable<String, SameJVMClientContainer>> _jvmClient = new EnvironmentLocal("caucho.jvm.client");
    String _serverId;
    AbstractServer _server;
    EJBHome _ejbHome;
    Class _homeStubClass;
    Class _remoteStubClass;

    public SameJVMClientContainer(AbstractServer server, String serverId) {
        this._serverId = serverId;
        this._server = server;
        Class beanSkelClass = server.getBeanSkelClass();
        Class cl = server.getHomeStubClass();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            if (cl != null) {
                this._homeStubClass = Class.forName(cl.getName(), false, loader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        cl = server.getRemoteStubClass();
        try {
            if (cl != null) {
                this._remoteStubClass = Class.forName(cl.getName(), false, loader);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
    }

    public static SameJVMClientContainer find(String serverId) {
        try {
            AbstractServer server;
            Hashtable<String, SameJVMClientContainer> map = _jvmClient.getLevel();
            SameJVMClientContainer client = null;
            if (map != null) {
                client = map.get(serverId);
            }
            if (client == null && (server = EjbProtocolManager.getJVMServer(serverId)) != null) {
                client = new SameJVMClientContainer(server, serverId);
                if (map == null) {
                    map = new Hashtable();
                }
                map.put(serverId, client);
                _jvmClient.set(map);
            }
            return client;
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
    }

    public Class getPrimaryKeyClass() {
        return this._server.getPrimaryKeyClass();
    }

    public EJBHome getEJBHome() throws RemoteException {
        try {
            return this.createHomeStub();
        }
        catch (Exception e) {
            throw RemoteExceptionWrapper.create(e);
        }
    }

    public EJBHome createHomeStub() throws Exception {
        if (this._homeStubClass == null && this._server.getRemoteHomeClass() != null) {
            Class cl = this._server.getRemoteHomeClass();
            Class remoteHomeClass = null;
            try {
                if (cl != null) {
                    remoteHomeClass = CauchoSystem.loadClass(cl.getName(), false, null);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (remoteHomeClass != null) {
                if (remoteHomeClass.equals(this._server.getRemoteHomeClass())) {
                    this._homeStubClass = this._server.getHomeStubClass();
                } else {
                    JVMHomeStubGenerator gen = new JVMHomeStubGenerator(remoteHomeClass, true);
                    gen.setClassDir(CauchoSystem.getWorkPath());
                    this._homeStubClass = gen.generateStub();
                }
            }
        }
        if (this._homeStubClass == null) {
            throw new EJBException(L.l("`{0}' is a local bean with no remote interface.  Local beans must be looked up with a local context.", this._serverId));
        }
        JVMHome homeStub = (JVMHome)this._homeStubClass.newInstance();
        homeStub._init(this._server);
        return homeStub;
    }

    public EJBObject createObjectStub(Object primaryKey) throws Exception {
        AbstractServer server = this.getServer();
        if (this._remoteStubClass == null && this._server.getRemoteObjectClass() != null) {
            Class cl = this._server.getRemoteObjectClass();
            Class remoteObjectClass = null;
            try {
                if (cl != null) {
                    remoteObjectClass = CauchoSystem.loadClass(cl.getName(), false, null);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (remoteObjectClass != null) {
                if (remoteObjectClass.equals(this._server.getRemoteObjectClass())) {
                    this._remoteStubClass = server.getRemoteStubClass();
                } else {
                    JVMObjectStubGenerator gen = new JVMObjectStubGenerator(remoteObjectClass, true);
                    gen.setClassDir(CauchoSystem.getWorkPath());
                    this._remoteStubClass = gen.generateStub();
                }
            }
        }
        if (this._remoteStubClass == null) {
            throw new EJBException(L.l("`{0}' is a local bean with no remote interface.  Local beans must be looked up with a local context.", this._serverId));
        }
        JVMObject objStub = (JVMObject)this._remoteStubClass.newInstance();
        objStub._init(server, primaryKey);
        return objStub;
    }

    public HandleEncoder getHandleEncoder(AbstractHandle handle) {
        try {
            AbstractServer server = this.getServer();
            if (server != null) {
                return server.getHandleEncoder();
            }
        }
        catch (Exception e) {
            throw EJBExceptionWrapper.createRuntime(e);
        }
        throw new EJBException("can't find server " + handle);
    }

    public AbstractServer getServer() throws RemoteException {
        AbstractServer jvmServer = EjbProtocolManager.getJVMServer(this._serverId);
        if (jvmServer != null) {
            return jvmServer;
        }
        throw new NoSuchObjectException(this._serverId);
    }

    public EJBObject getObject(Handle handle) {
        return null;
    }

    public String toString() {
        return "SameJVMClientContainer[" + this._serverId + "]";
    }
}

