/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.RemoteExceptionWrapper;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.SameJVMClientContainer;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;

public class HandleImpl
extends AbstractHandle {
    private String _serverId;
    private String _objectId;
    private transient EJBObject _object;

    public HandleImpl() {
    }

    public HandleImpl(String serverId, String objectId) {
        this._serverId = serverId;
        this._objectId = objectId;
    }

    public String getServerId() {
        return this._serverId;
    }

    public String getObjectId() {
        return this._objectId;
    }

    public String getURL(String protocol) {
        AbstractServer server = EjbProtocolManager.getJVMServer(this._serverId);
        return server.getHandleEncoder(protocol).getURL(this._objectId);
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this._object == null) {
            try {
                SameJVMClientContainer client = SameJVMClientContainer.find(this._serverId);
                if (client != null) {
                    this._object = client.createObjectStub(this._objectId);
                }
            }
            catch (Exception e) {
                RemoteExceptionWrapper.create(e);
            }
        }
        return this._object;
    }

    public boolean equals(Object b) {
        if (!(b instanceof HandleImpl)) {
            return false;
        }
        HandleImpl handle = (HandleImpl)b;
        return this._serverId.equals(handle._serverId) && this._objectId.equals(handle._objectId);
    }

    public int hashCode() {
        return 65521 * this._serverId.hashCode() + this._objectId.hashCode();
    }

    public String toString() {
        return "HandleImpl[" + this._serverId + "," + this._objectId + "]";
    }
}

