/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.protocol;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;

public abstract class ClientContainer {
    protected static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/protocol/ClientContainer"));
    protected static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/protocol/ClientContainer"));
    static final String CLIENT_KEY = "caucho.ejb.client";
    String _serverId;
    EJBLocalHome _localHomeStub;
    EJBHome _remoteHomeStub;
    LruCache<String, EJBObject> _stubMap = new LruCache(1024);
    protected HandleEncoder _handleEncoder;

    protected abstract EJBHome createHomeStub() throws Exception;

    protected abstract EJBObject createObjectStub(String var1) throws Exception;

    protected ClientContainer(String serverId) {
        this._serverId = serverId;
    }

    protected String getServerId() {
        return this._serverId;
    }

    public EJBHome getHomeStub() throws Exception {
        if (this._remoteHomeStub != null) {
            return this._remoteHomeStub;
        }
        this._remoteHomeStub = this.createHomeStub();
        return this._remoteHomeStub;
    }

    public Object getEJBLocalHome() {
        AbstractServer jvmServer = EjbProtocolManager.getJVMServer(this._serverId);
        return jvmServer.getClientLocalHome();
    }

    public HandleEncoder getHandleEncoder(AbstractHandle handle) {
        if (this._handleEncoder == null) {
            this._handleEncoder = new HandleEncoder("foo");
        }
        return this._handleEncoder;
    }

    public Class getPrimaryKeyClass() {
        return ClassLiteral.getClass((String)"java/lang/String");
    }

    public EJBObject getObjectStub(String url) throws Exception {
        EJBObject stub = this._stubMap.get(url);
        if (stub != null) {
            return stub;
        }
        stub = this.createObjectStub(url);
        this._stubMap.put(url, stub);
        return stub;
    }

    public String toString() {
        return "ClientContainer[" + this._serverId + "]";
    }
}

