/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.hessian.HessianProtocol;
import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.HessianWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;

public class NameContextSkeleton
extends Skeleton {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/hessian/NameContextSkeleton"));
    private HessianProtocol _protocol;
    private String _prefix;

    NameContextSkeleton(HessianProtocol protocol, String prefix) {
        this._protocol = protocol;
        this._prefix = prefix;
    }

    public void _service(InputStream is, OutputStream os) throws Exception {
        HessianReader in = new HessianReader(is);
        HessianWriter out = new HessianWriter(os);
        in.startCall();
        String method = in.getMethod();
        try {
            if (method.equals("lookup") || method.equals("lookup_string") || method.equals("lookup_1")) {
                this.executeLookup(in, out);
            } else if (method.equals("list")) {
                this.executeList(in, out);
            } else {
                this.executeUnknown(method, in, out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
    }

    private void executeLookup(HessianInput in, HessianOutput out) throws Throwable {
        String name = in.readString();
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(name);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeObject(home);
            out.completeReply();
        } else if (container.getRemoteChildren(name) != null) {
            out.startReply();
            String serverId = this._prefix + name;
            if (serverId.startsWith("/")) {
                serverId = serverId.substring(1);
            }
            out.writeRemote(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName(), this._protocol.getURLPrefix() + serverId);
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    private void executeList(HessianInput in, HessianOutput out) throws Throwable {
        in.completeCall();
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractServer server = container.getServerByEJBName(this._prefix);
        if (server != null) {
            EJBHome home = server.getEJBHome();
            out.startReply();
            out.writeNull();
            out.completeReply();
        } else {
            ArrayList<String> children = container.getRemoteChildren(this._prefix);
            if (children != null) {
                out.startReply();
                out.writeObject(children.toArray(new String[children.size()]));
                out.completeReply();
            } else {
                out.startReply();
                out.writeNull();
                out.completeReply();
            }
        }
    }

    protected void executeUnknown(String method, HessianInput in, HessianOutput out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName());
            } else if ("home-class".equals(key)) {
                out.writeString(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(ClassLiteral.getClass((String)"com/caucho/services/name/NameServerRemote").getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

