/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.MarshalGenerator;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.IntMap;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HessianSkeletonGenerator
extends MarshalGenerator {
    Class _cl;
    String _objClass;
    String _fullName;
    String _pkg;
    String _className;
    protected int _unique;
    protected ArrayList<Class> _marshallClasses;
    protected ArrayList<Class> _unmarshallClasses;
    protected ArrayList<Class> _marshallArrays;
    protected ArrayList<Class> _unmarshallArrays;
    protected Class _interfaceClass;
    protected ArrayList<PersistentDependency> _dependList;

    HessianSkeletonGenerator(Class interfaceClass) {
        this._interfaceClass = interfaceClass;
        this._dependList = new ArrayList();
        this._dependList.add(new ClassDependency(this._interfaceClass));
    }

    static Class generate(Class interfaceClass, Path workDir) throws Exception {
        HessianSkeletonGenerator gen = new HessianSkeletonGenerator(interfaceClass);
        gen.setClassDir(workDir);
        gen.setFullClassName(new StringBuffer().append("_ejb.").append(interfaceClass.getName()).append("__HessianSkel").toString());
        Class cl = gen.preload();
        if (cl != null) {
            return cl;
        }
        gen.generate();
        return gen.compile();
    }

    @Override
    public void generateJava() throws IOException {
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methods = this._interfaceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            methodList.add(methods[i]);
        }
        this.printHeader();
        IntMap methodMap = this.printDispatcher(methodList);
        this.printDependList(this._dependList);
        this.printFooter(methodMap);
    }

    void printHeader() throws IOException {
        if (this.getPackageName() != null) {
            this.println(new StringBuffer().append("package ").append(this.getPackageName()).append(";").toString());
        }
        this.println();
        this.println("import java.io.*;");
        this.println("import com.caucho.util.*;");
        this.println("import com.caucho.ejb.hessian.*;");
        this.println("import com.caucho.hessian.io.*;");
        this.println(new StringBuffer().append("import ").append(this._interfaceClass.getName()).append(";").toString());
        this.println();
        this.print(new StringBuffer().append("public class ").append(this.getClassName()).append(" extends com.caucho.ejb.hessian.HessianSkeleton").toString());
        this.println(" {");
        this.pushDepth();
        this.println(new StringBuffer().append("private ").append(this._interfaceClass.getName()).append(" obj;").toString());
        this.println();
        this.println("protected void _setObject(Object o)");
        this.println("{");
        this.println(new StringBuffer().append("  obj = (").append(this._interfaceClass.getName()).append(") o;").toString());
        this.println("}");
    }

    protected IntMap printDispatcher(ArrayList<Method> methods) throws IOException {
        IntMap map = new IntMap();
        this.println();
        this.print("protected void _execute(CharBuffer method, HessianInput in, HessianOutput out)");
        this.println("  throws Throwable");
        this.println("{");
        this.pushDepth();
        this.println("switch (methods.get(method)) {");
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            if (map.get(method.getName()) < 0) {
                map.put(method.getName(), i);
            }
            map.put(this.mangleMethodName(method.getName(), method, false), i);
            if (i > 0) {
                this.println();
            }
            this.println(new StringBuffer().append("case ").append(i).append(":").toString());
            this.pushDepth();
            this.println("{");
            this.pushDepth();
            this.printUnmarshal(method.getName(), method.getParameterTypes(), method.getReturnType());
            this.println("break;");
            this.popDepth();
            this.println("}");
            this.popDepth();
        }
        this.println("default:");
        this.println("  _executeUnknown(method, in, out);");
        this.println("  break;");
        this.println("}");
        this.popDepth();
        this.println("}");
        return map;
    }

    void printUnmarshal(String methodName, Class[] param, Class retType) throws IOException {
        for (int i = 0; i < param.length; ++i) {
            String var = new StringBuffer().append("_arg").append(i).toString();
            this.printClass(param[i]);
            this.print(new StringBuffer().append(" ").append(var).append(" = ").toString());
            this.printUnmarshalType(param[i]);
        }
        this.println("in.completeCall();");
        if (!retType.getName().equals("void")) {
            this.printClass(retType);
            this.print(" _ret = ");
        }
        this.printCall("obj", methodName, param);
        this.println("out.startReply();");
        if (!retType.equals(Void.TYPE)) {
            this.printMarshalType(retType, "_ret");
        } else {
            this.println("out.writeNull();");
        }
        this.println("out.completeReply();");
    }

    void printCall(String objName, String methodName, Class[] param) throws IOException {
        this.print(objName);
        this.print(".");
        this.print(methodName);
        this.print("(");
        for (int i = 0; i < param.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(new StringBuffer().append("_arg").append(i).toString());
        }
        this.println(");");
    }

    void printMetaMethod(IntMap map, int index, String methodName, Class[] param, Class retType) throws IOException {
        map.put(new StringBuffer().append("_hessian_").append(methodName).toString(), index);
        map.put(new StringBuffer().append("_hessian_").append(this.mangleMethodName(methodName, param, true)).toString(), index);
        this.println(new StringBuffer().append("case ").append(index).append(":").toString());
        this.println("{");
        this.pushDepth();
        for (int i = 0; i < param.length; ++i) {
            String var = new StringBuffer().append("_arg").append(i).toString();
            this.printClass(param[i]);
            this.println(new StringBuffer().append(" ").append(var).append(" = ").toString());
            this.printUnmarshalType(param[i]);
        }
        this.println("is.expectEndTag(\"hessian:call\");");
        if (!retType.getName().equals("void")) {
            this.printClass(retType);
            this.println(" _ret;");
        }
        if (!retType.getName().equals("void")) {
            this.print("_ret = ");
        }
        this.printCall("this", methodName, param);
        this.println("os.print(\"<hessian:reply><value>\");");
        if (!retType.equals(Void.TYPE)) {
            this.printMarshalType(retType, "_ret");
        } else {
            this.print("os.print(\"<null></null>\");");
        }
        this.println("os.print(\"</value></hessian:reply>\");");
        this.println("break;");
        this.popDepth();
        this.println("}");
    }

    String getMethodName(Method method) {
        return method.getName();
    }

    protected void printFooter(IntMap methodMap) throws IOException {
        this.println("static private IntMap methods = new IntMap();");
        this.println("static {");
        this.pushDepth();
        Iterator keys = methodMap.iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            int value = methodMap.get(name);
            this.println(new StringBuffer().append("methods.put(new CharBuffer(\"").append(name).append("\"),").append(value).append(");").toString());
        }
        this.popDepth();
        this.println("}");
        this.popDepth();
        this.println("}");
    }
}

