/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.ejb.hessian.HessianHandle;
import com.caucho.ejb.hessian.HessianHomeHandle;
import com.caucho.ejb.protocol.AbstractHandle;
import com.caucho.ejb.protocol.AbstractHomeHandle;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Field;
import javax.ejb.EJBException;

public class HessianHandleEncoder
extends HandleEncoder {
    private static char[] _serverEncode64;
    private static int[] _serverHash64;
    private static char[] _serverEncodeH2;
    private Class _primaryKeyClass;
    private Field[] _fields;
    private int[] _fieldTypes;

    public HessianHandleEncoder(AbstractServer server, String serverId, Class primaryKeyClass) throws ConfigException {
        super(serverId);
        this._primaryKeyClass = primaryKeyClass;
        if (this._primaryKeyClass == null || this._primaryKeyClass.isPrimitive() || this._primaryKeyClass.getName().startsWith("java.lang.")) {
            return;
        }
        this._fields = this._primaryKeyClass.getFields();
        this._fieldTypes = new int[this._fields.length];
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i].setAccessible(true);
        }
        this.setServer(server);
    }

    public AbstractHomeHandle createHomeHandle() {
        try {
            return new HessianHomeHandle(this.getServer().getEJBHome(), this.getServerId());
        }
        catch (Throwable e) {
            return new HessianHomeHandle(this.getServerId());
        }
    }

    public AbstractHandle createHandle(String objectId) {
        HessianHandle handle = new HessianHandle(this.getURL(objectId), objectId);
        return handle;
    }

    public String createRandomStringKey() {
        String originalKey = super.createRandomStringKey();
        int srun = 0;
        int tail = this.calculateHash(originalKey) * 65521;
        CharBuffer cb = CharBuffer.allocate();
        cb.append(originalKey);
        int d1 = 64 + srun - tail & 0x3F;
        cb.append(_serverEncode64[d1]);
        return cb.close();
    }

    private int calculateHash(String key) {
        int hash = 137;
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            hash = 65521 * hash + _serverHash64[ch & 0xFF];
        }
        return hash;
    }

    public Object objectIdToKey(Object objectKey) {
        String objectId = (String)objectKey;
        if (this._primaryKeyClass == null) {
            return objectId;
        }
        if (this._primaryKeyClass.equals(ClassLiteral.getClass((String)"java/lang/String"))) {
            return objectId;
        }
        if (this._primaryKeyClass.equals(ClassLiteral.getClass((String)"java/lang/Integer")) || this._primaryKeyClass.equals(Integer.TYPE)) {
            return new Integer(objectId);
        }
        if (this._primaryKeyClass.equals(ClassLiteral.getClass((String)"java/lang/Long")) || this._primaryKeyClass.equals(Long.TYPE)) {
            return new Long(objectId);
        }
        if (this._primaryKeyClass.equals(ClassLiteral.getClass((String)"java/lang/Float")) || this._primaryKeyClass.equals(Float.TYPE)) {
            return new Float(objectId);
        }
        if (this._primaryKeyClass.equals(ClassLiteral.getClass((String)"java/lang/Double")) || this._primaryKeyClass.equals(Double.TYPE)) {
            return new Double(objectId);
        }
        if (this._fields != null) {
            Object obj;
            try {
                obj = this._primaryKeyClass.newInstance();
                int length = objectId.length();
                int j = 0;
                CharBuffer cb = new CharBuffer();
                for (int i = 0; i < this._fields.length; ++i) {
                    cb.clear();
                    while (j < length && objectId.charAt(j) != ',') {
                        cb.append(objectId.charAt(j));
                        ++j;
                    }
                    ++j;
                    String field = cb.toString();
                    Class<?> fieldClass = this._fields[i].getType();
                    if (fieldClass.equals(ClassLiteral.getClass((String)"java/lang/String"))) {
                        this._fields[i].set(obj, field);
                        continue;
                    }
                    if (fieldClass.equals(Integer.TYPE)) {
                        this._fields[i].setInt(obj, Integer.parseInt(field));
                        continue;
                    }
                    if (fieldClass.equals(ClassLiteral.getClass((String)"java/lang/Integer"))) {
                        this._fields[i].set(obj, new Integer(field));
                        continue;
                    }
                    if (fieldClass.equals(Long.TYPE)) {
                        this._fields[i].setLong(obj, Long.parseLong(field));
                        continue;
                    }
                    if (fieldClass.equals(ClassLiteral.getClass((String)"java/lang/Long"))) {
                        this._fields[i].set(obj, new Long(field));
                        continue;
                    }
                    if (fieldClass.equals(Float.TYPE)) {
                        this._fields[i].setFloat(obj, (float)Double.parseDouble(field));
                        continue;
                    }
                    if (fieldClass.equals(ClassLiteral.getClass((String)"java/lang/Float"))) {
                        this._fields[i].set(obj, new Float(field));
                        continue;
                    }
                    if (fieldClass.equals(Double.TYPE)) {
                        this._fields[i].setDouble(obj, Double.parseDouble(field));
                        continue;
                    }
                    if (fieldClass.equals(ClassLiteral.getClass((String)"java/lang/Double"))) {
                        this._fields[i].set(obj, new Double(field));
                        continue;
                    }
                    throw new RuntimeException();
                }
                ++j;
            }
            catch (Exception e) {
                throw EJBExceptionWrapper.create(e);
            }
            return obj;
        }
        throw new EJBException("bad primary key class");
    }

    static {
        int i;
        int i2;
        _serverEncode64 = new char[64];
        for (i2 = 0; i2 < 26; ++i2) {
            HessianHandleEncoder._serverEncode64[i2] = (char)(97 + i2);
            HessianHandleEncoder._serverEncode64[i2 + 26] = (char)(65 + i2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            HessianHandleEncoder._serverEncode64[i2 + 52] = (char)(48 + i2);
        }
        HessianHandleEncoder._serverEncode64[62] = 45;
        HessianHandleEncoder._serverEncode64[63] = 95;
        _serverHash64 = new int[256];
        for (i2 = 0; i2 < 26; ++i2) {
            HessianHandleEncoder._serverHash64[97 + i2] = i2;
            HessianHandleEncoder._serverHash64[65 + i2] = i2 + 26;
        }
        for (i2 = 0; i2 < 10; ++i2) {
            HessianHandleEncoder._serverHash64[48 + i2] = 52 + i2;
        }
        HessianHandleEncoder._serverHash64[45] = 62;
        HessianHandleEncoder._serverHash64[95] = 63;
        int j = 64;
        for (i = 0; i < 256; ++i) {
            if (_serverHash64[i] != 0) continue;
            HessianHandleEncoder._serverHash64[i] = j++;
        }
        _serverEncodeH2 = new char[64];
        j = 0;
        for (i = 0; i < 64; ++i) {
            HessianHandleEncoder._serverEncodeH2[j] = _serverEncode64[i];
            j = (j + 49) % 64;
        }
    }
}

