/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.ejb.gen.SessionPoolChain;
import com.caucho.ejb.gen.StatelessPoolChain;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.CallChain;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class SessionView
extends ViewClass {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/gen/SessionView"));
    private Class _remoteClass;
    private String _prefix;
    private String _contextClassName;
    private boolean _isStateless;

    public SessionView(Class remoteClass, String contextClassName, String prefix, boolean isStateless) {
        super(prefix, isStateless ? "StatelessObject" : "SessionObject");
        this.addInterfaceName(remoteClass.getName());
        this._contextClassName = contextClassName;
        this._prefix = prefix;
        this._isStateless = isStateless;
        this.setStatic(true);
    }

    public CallChain createPoolChain(CallChain call) {
        if (this._isStateless) {
            return new StatelessPoolChain(call);
        }
        return new SessionPoolChain(call);
    }

    public void generate(JavaWriter out) throws IOException {
        this.generateGetter(out);
        out.println();
        super.generate(out);
    }

    private void generateGetter(JavaWriter out) throws IOException {
        out.println("private " + this._prefix + " _view" + this._prefix + ";");
        out.println();
        if (this._prefix.equals("Local")) {
            out.println("public EJBLocalObject getEJBLocalObject()");
        } else {
            out.println("public EJBObject getRemoteView()");
        }
        out.println("{");
        out.println("  if (_view" + this._prefix + " == null)");
        out.println("    _view" + this._prefix + " = new " + this._prefix + "(this);");
        out.println();
        out.println("  return _view" + this._prefix + ";");
        out.println("}");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        out.println("private final " + this._contextClassName + " _context;");
        out.println("private final EjbTransactionManager _xaManager;");
        out.println();
        out.println(this._prefix + "(" + this._contextClassName + " context)");
        out.println("{");
        if (this._isStateless) {
            out.println("  super(context.getStatelessServer());");
        } else {
            out.println("  super(context.getSessionServer());");
        }
        out.println("  _context = context;");
        out.println("  _xaManager = _server.getTransactionManager();");
        out.println("}");
        out.println();
        out.println("private " + this._contextClassName + " getContext()");
        out.println("{");
        out.println("  return _context;");
        out.println("}");
        if (!this._isStateless) {
            out.println();
            out.println("public String __caucho_getId()");
            out.println("{");
            out.println("  return _context.getPrimaryKey();");
            out.println("}");
        }
        out.println();
        this.generateComponents(out);
    }
}

