/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.doclet;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Signature;
import com.caucho.doclet.ClassDocImpl;
import com.caucho.doclet.DocImpl;
import com.caucho.doclet.MethodDocImpl;
import com.caucho.doclet.TagImpl;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EjbHomeGenerator {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/doclet/EjbHomeGenerator"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/doclet/EjbHomeGenerator"));
    private ClassDocImpl _classDoc;
    private boolean _isLocal = true;
    private String _fullClassName;
    private String _shortClassName;
    private String _package;
    private String _interfaceName;
    private String _primKeyClass;

    EjbHomeGenerator(ClassDocImpl classDoc) {
        this._classDoc = classDoc;
    }

    public void setLocal(boolean isLocal) {
        this._isLocal = isLocal;
    }

    public void setClassName(String className) {
        this._fullClassName = className;
        int p = className.lastIndexOf(46);
        if (p > 0) {
            this._shortClassName = className.substring(p + 1);
            this._package = className.substring(0, p);
        } else {
            this._shortClassName = className;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Path path) throws IOException, ConfigException {
        this._interfaceName = this._classDoc.getAttribute("@ejb.interface", "local-class");
        this._primKeyClass = this._classDoc.getAttribute("@ejb.pk", "class");
        if (this._primKeyClass == null) {
            this._primKeyClass = "java.lang.String";
        }
        path.getParent().mkdirs();
        WriteStream os = path.openWrite();
        try {
            JavaWriter out = new JavaWriter(os);
            this.generate(out);
        }
        finally {
            os.close();
        }
    }

    public void generate(JavaWriter out) throws IOException, ConfigException {
        out.println("/**");
        out.println(" * home interface generated by Resin-EE doclet.");
        out.println(" * on " + QDate.formatLocal(Alarm.getCurrentTime()));
        out.println(" */");
        if (this._package != null) {
            out.println();
            out.println("package " + this._package + ";");
        }
        out.println();
        out.println("public interface " + this._shortClassName);
        if (this._isLocal) {
            String localExtends = this._classDoc.getAttribute("@ejb.home", "local-extends");
            if (localExtends == null) {
                localExtends = "javax.ejb.EJBLocalHome";
            }
            out.println("  extends " + localExtends + " {");
        } else {
            String remoteExtends = this._classDoc.getAttribute("@ejb.home", "extends");
            if (remoteExtends == null) {
                remoteExtends = "javax.ejb.EJBHome";
            }
            out.println("  extends " + remoteExtends + " {");
        }
        out.pushDepth();
        out.println();
        out.print("public " + this._interfaceName + " findByPrimaryKey(");
        out.println(this._primKeyClass + " key)");
        out.println("  throws javax.ejb.FinderException;");
        this.generateFind(out);
        this.generateCreate(out);
        out.popDepth();
        out.println("}");
    }

    public void generateCreate(JavaWriter out) throws IOException, ConfigException {
        ArrayList<MethodDocImpl> methodList = this._classDoc.getMethods();
        for (int i = 0; i < methodList.size(); ++i) {
            MethodDocImpl method = methodList.get(i);
            if (!method.getName().equals("ejbCreate")) continue;
            out.println();
            out.print("public " + this._interfaceName + " create(");
            ArrayList<MethodDocImpl.Param> paramList = method.getParameters();
            for (int j = 0; j < paramList.size(); ++j) {
                MethodDocImpl.Param param = paramList.get(j);
                if (j > 0) {
                    out.print(", ");
                }
                out.print(param.getType() + " " + param.getName());
            }
            out.println(")");
            out.println("  throws javax.ejb.CreateException;");
        }
    }

    public void generateFind(JavaWriter out) throws IOException, ConfigException {
        ArrayList<TagImpl> tagList = this._classDoc.getTagList("@ejb.finder");
        if (tagList == null) {
            return;
        }
        for (int i = 0; i < tagList.size(); ++i) {
            TagImpl tag = tagList.get(i);
            String signature = tag.getAttribute("signature");
            Signature sig = new Signature();
            sig.addText(signature);
            sig.init();
            out.println();
            out.print("public " + sig.getReturnType() + " ");
            out.print(sig.getName() + "(");
            String[] param = sig.getParameterTypes();
            for (int j = 0; j < param.length; ++j) {
                if (j != 0) {
                    out.print(", ");
                }
                out.print(param[j] + " a" + j);
            }
            out.println(") throws javax.ejb.FinderException;");
        }
    }

    private ConfigException error(DocImpl loc, String msg) {
        if (loc == null) {
            return new ConfigException(msg);
        }
        if (loc.getPosition() == null) {
            return new ConfigException(loc.getName() + ": " + msg);
        }
        return new LineConfigException(loc.getPosition() + msg);
    }
}

