/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Signature;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class MethodSignature {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/MethodSignature"));
    private static IntMap _methodElements;
    private String _ejbName;
    private EjbBean _bean;
    private String _methodName;
    private String _methodIntf;
    private Object _value;
    private ArrayList<String> _paramTypes;

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        if (this._bean != null) {
            return this._bean.getEJBName();
        }
        return this._ejbName;
    }

    public void setMethodName(String name) throws ConfigException {
        this.setName(name);
    }

    public String getName() {
        return this._methodName;
    }

    public void setName(String methodName) throws ConfigException {
        if (methodName.indexOf(40) < 0) {
            this._methodName = methodName;
            return;
        }
        Signature sig = new Signature();
        sig.addText(methodName);
        sig.init();
        this._methodName = sig.getName();
        String[] params = sig.getParameterTypes();
        if (params != null) {
            this._paramTypes = new ArrayList();
            for (int i = 0; i < params.length; ++i) {
                this._paramTypes.add(params[i]);
            }
        }
    }

    public void addText(String text) throws ConfigException {
        this.setName(text);
    }

    public void addParam(String typeName) {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList();
        }
        this._paramTypes.add(typeName);
    }

    public MethodParams createMethodParams() {
        return new MethodParams();
    }

    public void setHasParams() {
        if (this._paramTypes == null) {
            this._paramTypes = new ArrayList();
        }
    }

    public void setMethodIntf(String intf) {
        this._methodIntf = intf;
    }

    boolean isHome() {
        return this._methodIntf == null || this._methodIntf.equals("Home");
    }

    boolean isRemote() {
        return this._methodIntf == null || this._methodIntf.equals("Remote");
    }

    boolean isLocalHome() {
        return this._methodIntf == null || this._methodIntf.equals("LocalHome");
    }

    boolean isLocal() {
        return this._methodIntf == null || this._methodIntf.equals("Local");
    }

    int getCost() {
        int cost;
        int n = cost = this._methodIntf == null ? 0 : 1;
        if (this._methodName.equals("*")) {
            return cost;
        }
        if (this._paramTypes == null) {
            return 2 + cost;
        }
        return 4 + cost;
    }

    public boolean isMatch(Method method, String intf) {
        if (method == null) {
            return this._methodName.equals("*");
        }
        return this.isMatch(method.getName(), method.getParameterTypes(), intf);
    }

    public boolean isMatch(String methodName, Class[] params, String intf) {
        if (this._methodIntf != null && !this._methodIntf.equals(intf)) {
            return false;
        }
        if (this._methodName == null) {
            return false;
        }
        if (this._methodName.equals("*")) {
            return true;
        }
        if (!this._methodName.equals(methodName)) {
            return false;
        }
        if (this._paramTypes == null) {
            return true;
        }
        if (params.length != this._paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            String param;
            String name = params[i].getName();
            if (name.equals(param = this._paramTypes.get(i)) || name.endsWith("." + param)) continue;
            return false;
        }
        return true;
    }

    void setValue(Object value) {
        this._value = value;
    }

    Object getValue() {
        return this._value;
    }

    public int hashCode() {
        return this._methodName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature cfg = (MethodSignature)o;
        if (!this._methodName.equals(cfg._methodName)) {
            return false;
        }
        if (this._paramTypes == null || cfg._paramTypes == null) {
            return this._paramTypes == cfg._paramTypes;
        }
        if (this._paramTypes.size() != cfg._paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < this._paramTypes.size(); ++i) {
            if (this._paramTypes.get(i).equals(cfg._paramTypes.get(i))) continue;
            return false;
        }
        if (this._methodIntf == cfg._methodIntf) {
            return true;
        }
        if (this._methodIntf == null || cfg._methodIntf == null) {
            return false;
        }
        return this._methodIntf.equals(cfg._methodIntf);
    }

    public String toSignatureString() {
        CharBuffer cb = new CharBuffer();
        cb.append(this._methodName);
        cb.append("(");
        for (int i = 0; this._paramTypes != null && i < this._paramTypes.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._paramTypes.get(i));
        }
        cb.append(")");
        return cb.toString();
    }

    public String toString() {
        return "MethodSignature[" + this.toSignatureString() + "]";
    }

    public class MethodParams {
        public void addMethodParam(String value) {
            MethodSignature.this.addParam(value);
        }
    }
}

