/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.EntityManyToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbManyToManyMethod;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbView;
import com.caucho.ejb.cfg.SqlRelation;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmrManyToMany
extends CmrRelation {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/CmrManyToMany"));
    private String _sqlTable;
    private EjbEntityBean _targetBean;
    private String _targetField;
    private boolean _isTargetUnique;
    private SqlRelation[] _keySQLColumns;
    private SqlRelation[] _dstSQLColumns;
    private EntityManyToManyField _amberManyToMany;

    public CmrManyToMany(EjbEntityBean entityBean, String fieldName, EjbEntityBean targetBean, String targetField) throws ConfigException {
        super(entityBean, fieldName);
        this._targetBean = targetBean;
        this._targetField = targetField;
    }

    @Override
    public EjbEntityBean getTargetBean() {
        return this._targetBean;
    }

    public void setSQLTable(String sqlTable) {
        this._sqlTable = sqlTable;
    }

    public String getSQLTable() {
        if (this._sqlTable != null) {
            return this._sqlTable;
        }
        return this.getRelationName();
    }

    public void setTargetUnique(boolean isUnique) {
        this._isTargetUnique = isUnique;
    }

    public boolean isTargetUnique() {
        return this._isTargetUnique;
    }

    @Override
    public Class getTargetType() {
        return this._targetBean.getLocal();
    }

    public void setKeySQLColumns(SqlRelation[] columns) {
        this._keySQLColumns = columns;
    }

    public SqlRelation[] getKeySQLColumns() {
        return this._keySQLColumns;
    }

    public void setDstSQLColumns(SqlRelation[] columns) {
        this._dstSQLColumns = columns;
    }

    public SqlRelation[] getDstSQLColumns() {
        return this._dstSQLColumns;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public EntityManyToManyField getAmberField() {
        return this._amberManyToMany;
    }

    @Override
    public EjbMethod createGetter(EjbView view, Method apiMethod, Method implMethod) throws ConfigException {
        return new EjbManyToManyMethod(view, apiMethod, implMethod, this);
    }

    @Override
    public AmberField assembleAmber(EntityType type) throws ConfigException {
        EntityManyToManyField manyToMany;
        AmberManager manager = type.getAmberManager();
        Table map = manager.createTable(this.getSQLTable());
        this._amberManyToMany = manyToMany = new EntityManyToManyField(type, this.getName());
        manyToMany.setAssociationTable(map);
        EntityType targetType = this._targetBean.getEntityType();
        manyToMany.setType(targetType);
        ArrayList<ForeignColumn> targetColumns = this.calculateColumns(map, targetType, this._targetField, this._dstSQLColumns);
        manyToMany.setTargetLink(new LinkColumns(map, targetType.getTable(), targetColumns));
        EntityType sourceType = this.getBean().getEntityType();
        ArrayList<ForeignColumn> sourceColumns = this.calculateColumns(map, sourceType, this.getName(), this._keySQLColumns);
        manyToMany.setSourceLink(new LinkColumns(map, sourceType.getTable(), sourceColumns));
        manyToMany.init();
        return manyToMany;
    }

    private ArrayList<ForeignColumn> calculateColumns(Table mapTable, EntityType type, String fieldName, SqlRelation[] sqlColumns) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        Id id = type.getId();
        ArrayList<Column> keys = id.getColumns();
        if (sqlColumns != null && sqlColumns.length == keys.size()) {
            for (int i = 0; i < sqlColumns.length; ++i) {
                ForeignColumn column = mapTable.createForeignColumn(sqlColumns[i].getSQLColumn(), keys.get(i));
                columns.add(column);
            }
        } else if (keys.size() == 1) {
            Column key = keys.get(0);
            String sqlColumn = type.getTable().getName() != null ? type.getTable().getName() : CmpField.toSqlName(type.getName());
            columns.add(mapTable.createForeignColumn(sqlColumn, key));
        } else {
            String baseSqlColumn = sqlColumns != null && sqlColumns.length == 1 ? sqlColumns[0].getSQLColumn() : type.getTable().getName();
            if (baseSqlColumn == null) {
                baseSqlColumn = CmpField.toSqlName(type.getName());
            }
            for (int i = 0; i < keys.size(); ++i) {
                Column key = keys.get(i);
                String sqlColumn = new StringBuffer().append(baseSqlColumn).append("_").append(key.getName()).toString();
                ForeignColumn foreignColumn = mapTable.createForeignColumn(sqlColumn, key);
                columns.add(foreignColumn);
            }
        }
        return columns;
    }
}

