/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.ejb.burlap.BurlapStub;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.ejb.burlap.StubGenerator;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BurlapStubFactory
implements HessianRemoteResolver {
    private HessianRemoteResolver _resolver = this;
    private Path _workPath;

    public HessianRemoteResolver getRemoteResolver() {
        return this._resolver;
    }

    public void setWorkPath(Path path) {
        this._workPath = path;
    }

    public Path getWorkPath() {
        return this._workPath;
    }

    public Object create(Class api, String url) throws Exception {
        StubGenerator gen = new StubGenerator();
        gen.setClassDir(this.getWorkPath());
        Class cl = gen.createStub(api);
        BurlapStub stub = (BurlapStub)cl.newInstance();
        stub._burlap_setURLPath(Vfs.lookup(url));
        stub._burlap_setClientContainer(this);
        return stub;
    }

    public AbstractHessianInput getBurlapInput(InputStream is) {
        BurlapInput in = new BurlapInput(is);
        in.setRemoteResolver(this._resolver);
        return in;
    }

    public AbstractHessianOutput getBurlapOutput(OutputStream os) {
        return new BurlapWriter(os);
    }

    public Object lookup(String type, String url) throws IOException {
        try {
            Class api = CauchoSystem.loadClass(type);
            return this.create(api, url);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            IOException e1 = new IOException(e.toString());
            e1.initCause(e);
            throw e1;
        }
    }
}

