/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.burlap.BurlapProtocolException;
import com.caucho.ejb.burlap.BurlapReader;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BurlapSkeleton
extends Skeleton {
    protected static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/burlap/BurlapSkeleton"));
    private AbstractServer _server;
    private HessianRemoteResolver _resolver;

    protected abstract void _setObject(Object var1);

    protected abstract void _execute(CharBuffer var1, BurlapInput var2, BurlapOutput var3) throws Throwable;

    void _setServer(AbstractServer server) {
        this._server = server;
    }

    void _setResolver(HessianRemoteResolver resolver) {
        this._resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _service(InputStream is, OutputStream os) throws Exception {
        BurlapReader in = new BurlapReader(is);
        BurlapWriter out = new BurlapWriter(os);
        in.setRemoteResolver(this._resolver);
        in.startCall();
        String method = in.getMethod();
        CharBuffer cb = new CharBuffer();
        cb.append(method);
        String oldProtocol = EjbProtocolManager.setThreadProtocol("burlap");
        try {
            this._execute(cb, in, out);
        }
        catch (BurlapProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
        }
        finally {
            EjbProtocolManager.setThreadProtocol(oldProtocol);
        }
    }

    protected void _executeUnknown(CharBuffer method, BurlapInput in, BurlapOutput out) throws Exception {
        if (method.matches("_burlap_getAttribute")) {
            String key = in.readString();
            in.completeCall();
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else if ("home-class".equals(key)) {
                out.writeString(this._server.getRemoteHomeClass().getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(this._server.getRemoteObjectClass().getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

