/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.ejb.burlap.BurlapClientContainer;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.services.name.NameServerRemote;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.ejb.EJBHome;
import javax.naming.NamingException;

public class BurlapModel
extends AbstractModel {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/burlap/BurlapModel"));
    private String _urlPrefix;
    private String _namePrefix;
    private BurlapModel _root;
    private Hashtable _cache;
    private BurlapClientContainer _client;
    private NameServerRemote _remoteRoot;
    private NameServerRemote _remote;

    public BurlapModel(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this._urlPrefix = prefix;
        this._namePrefix = "/";
        this._root = this;
        this._cache = new Hashtable();
    }

    public BurlapModel(String namePrefix, BurlapModel root) {
        if (!namePrefix.endsWith("/")) {
            namePrefix = namePrefix + '/';
        }
        this._namePrefix = namePrefix;
        this._root = root;
    }

    void setRemote(NameServerRemote remote) {
        this._remote = remote;
    }

    void setClientContainer(BurlapClientContainer client) {
        this._root._client = client;
    }

    public AbstractModel copy() {
        return this;
    }

    String getURLPrefix() {
        return this._root._urlPrefix;
    }

    public Object lookup(String name) throws NamingException {
        try {
            Object obj = this._root._cache.get(this.getURLPrefix() + this._namePrefix + name);
            if (obj != null) {
                return obj;
            }
            if (this._root._remoteRoot == null) {
                if (this._root._client == null) {
                    this._root._client = BurlapClientContainer.find(this.getURLPrefix());
                }
                this._root._remoteRoot = (NameServerRemote)this._client.createObjectStub(this.getURLPrefix());
            }
            if ((obj = this._root._remoteRoot.lookup(this._namePrefix + name)) instanceof EJBHome) {
                this._root._cache.put(name, obj);
            } else if (obj instanceof NameServerRemote) {
                BurlapModel model = new BurlapModel(this._namePrefix + name, this._root);
                this._remote = (NameServerRemote)obj;
                model.setRemote(this._remote);
                obj = model;
                this._root._cache.put(name, obj);
            }
            return obj;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public List list() throws NamingException {
        try {
            if (this._remote == null) {
                Object obj;
                if (this._root._remoteRoot == null) {
                    if (this._root._client == null) {
                        this._root._client = BurlapClientContainer.find(this.getURLPrefix());
                    }
                    this._root._remoteRoot = (NameServerRemote)this._client.createObjectStub(this.getURLPrefix());
                }
                if ((obj = this._root._remoteRoot.lookup(this._namePrefix)) instanceof NameServerRemote) {
                    this._remote = (NameServerRemote)obj;
                }
            }
            if (this._remote == null) {
                throw new NamingException(L.l("Burlap object `{0}' is not a context.", this.getURLPrefix() + this._namePrefix));
            }
            String[] list = this._remote.list();
            ArrayList<String> value = new ArrayList<String>();
            for (int i = 0; list != null && i < list.length; ++i) {
                value.add(list[i]);
            }
            return value;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public String toString() {
        return "BurlapModel[url= " + this.getURLPrefix() + ",name=" + this._namePrefix + "]";
    }
}

