/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.amber.AmberManager;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EJBServerInterface;
import com.caucho.ejb.admin.EJBAdmin;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.entity.EntityKey;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.entity.QEntityContext;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.xa.EjbTransactionManager;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServerManager
implements EJBServerInterface {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/EjbServerManager"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/EjbServerManager"));
    private static EnvironmentLocal<EjbServerManager> _localServerManager = new EnvironmentLocal("caucho.ejb-server");
    private EnhancingClassLoader _classLoader;
    private Path _workPath;
    private boolean _autoCompile = true;
    private int _entityCacheSize = 32768;
    private long _entityCacheTimeout = 5000L;
    private boolean _entityLoadLazyOnTransaction = true;
    protected boolean _allowJVMCall = true;
    protected boolean _allowReferenceCall = true;
    protected boolean _createDatabaseSchema;
    protected boolean _validateDatabaseSchema;
    private boolean _hasInitJdbc;
    private ConfigException _initException;
    private EjbConfig _ejbConfig;
    private EJBAdmin _ejbAdmin;
    private AmberManager _amberManager;
    private EjbTransactionManager _ejbTransactionManager;
    private EjbProtocolManager _protocolManager;
    protected ConnectionFactory _jmsConnectionFactory;
    private Hashtable<String, AbstractServer> _serverMap = new Hashtable();
    protected ProtocolContainer _protocolContainer;
    protected HashMap<String, ProtocolContainer> _protocolMap = new HashMap();
    private LruCache<EntityKey, QEntityContext> _entityCache;
    private EntityKey _entityKey = new EntityKey();
    private final Lifecycle _lifecycle = new Lifecycle(log, "ejb-manager");

    private EjbServerManager() {
        try {
            this._amberManager = new AmberManager();
            this._amberManager.initLoaders();
            this._amberManager.setTableCacheTimeout(this._entityCacheTimeout);
            this._classLoader = this._amberManager.getEnhancedLoader();
            this._workPath = WorkDir.getLocalWorkDir(this._classLoader).lookup("ejb");
            this._classLoader.addLoader(new SimpleLoader(this._workPath));
            this._ejbTransactionManager = new EjbTransactionManager(this);
            this._ejbConfig = new EjbConfig(this);
            this._ejbAdmin = new EJBAdmin(this);
            this._protocolManager = new EjbProtocolManager(this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Class<?> entityManagerClass = Class.forName("com.caucho.ejb.entity2.EntityManagerProxy");
            Object entityProxy = entityManagerClass.newInstance();
            new InitialContext().rebind("java:comp/EntityManager", entityProxy);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public static EjbServerManager getLocal() {
        return _localServerManager.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbServerManager createLocal() {
        Class clazz = ClassLiteral.getClass((String)"com/caucho/ejb/EjbServerManager");
        synchronized (clazz) {
            EjbServerManager serverManager = _localServerManager.getLevel();
            if (serverManager == null) {
                serverManager = new EjbServerManager();
                _localServerManager.set(serverManager);
            }
            return serverManager;
        }
    }

    public EnhancingClassLoader getClassLoader() {
        return this._classLoader;
    }

    public EnvironmentClassLoader getRawLoader() {
        return this._classLoader.getRawLoader();
    }

    public EjbProtocolManager getProtocolManager() {
        return this._protocolManager;
    }

    public EjbTransactionManager getTransactionManager() {
        return this._ejbTransactionManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._amberManager.setDataSource(dataSource);
    }

    public DataSource getDataSource() {
        return this._amberManager.getDataSource();
    }

    public void setResinIsolation(int resinIsolation) {
        this._ejbTransactionManager.setResinIsolation(resinIsolation);
    }

    public int getResinIsolation() {
        return this._ejbTransactionManager.getResinIsolation();
    }

    public void setJDBCIsolation(int jdbcIsolation) {
        this._ejbTransactionManager.setJDBCIsolation(jdbcIsolation);
    }

    public int getJDBCIsolation() {
        return this._ejbTransactionManager.getJDBCIsolation();
    }

    public long getTransactionTimeout() {
        return this._ejbTransactionManager.getTransactionTimeout();
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this._ejbTransactionManager.setTransactionTimeout(transactionTimeout);
    }

    public boolean isEntityLoadLazyOnTransaction() {
        return this._entityLoadLazyOnTransaction;
    }

    public void setEntityLoadLazyOnTransaction(boolean isLazy) {
        this._entityLoadLazyOnTransaction = isLazy;
    }

    public void setJMSConnectionFactory(ConnectionFactory factory) {
        this._jmsConnectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._jmsConnectionFactory;
    }

    public Path getWorkPath() {
        return this._workPath;
    }

    public void setWorkPath(Path workPath) {
    }

    public boolean isAutoCompile() {
        return this._autoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this._autoCompile = autoCompile;
    }

    public boolean isAllowPOJO() {
        return this._ejbConfig.isAllowPOJO();
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._ejbConfig.setAllowPOJO(allowPOJO);
    }

    public void setAllowJVMCall(boolean allowJVMCall) {
        this._allowJVMCall = allowJVMCall;
    }

    public void setAllowReferenceCall(boolean allowReferenceCall) {
        this._allowReferenceCall = allowReferenceCall;
    }

    public void setCreateDatabaseSchema(boolean create) {
        this._createDatabaseSchema = create;
        this._amberManager.setCreateDatabaseTables(create);
    }

    public boolean getCreateDatabaseSchema() {
        return this._createDatabaseSchema;
    }

    public void setValidateDatabaseSchema(boolean validate) {
        this._validateDatabaseSchema = validate;
        this._amberManager.setValidateDatabaseTables(validate);
    }

    public boolean getValidateDatabaseSchema() {
        return this._validateDatabaseSchema;
    }

    public long getCacheTimeout() {
        return this._entityCacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this._entityCacheTimeout = cacheTimeout;
        this._amberManager.setTableCacheTimeout(cacheTimeout);
    }

    public int getCacheSize() {
        return this._entityCacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._entityCacheSize = cacheSize;
    }

    public EJBAdmin getAdmin() {
        return this._ejbAdmin;
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    @Override
    public void addEJBJar(Path path) throws Exception {
        Path metaInf;
        JarPath jar = JarPath.create(path);
        Path descriptorPath = jar.lookup("META-INF/ejb-jar.xml");
        if (descriptorPath.exists()) {
            this.addEJBPath(descriptorPath);
        }
        if ((metaInf = jar.lookup("META-INF")).isDirectory()) {
            String[] metaList = metaInf.list();
            for (int j = 0; j < metaList.length; ++j) {
                String metaName = metaList[j];
                if (!metaName.endsWith(".ejb")) continue;
                Path metaPath = metaInf.lookup(metaName);
                this.addEJBPath(metaPath);
            }
        }
    }

    public void addEJBPath(Path path) throws ConfigException {
        this._ejbConfig.addEJBPath(path);
    }

    @Override
    public void initEJBs() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.build();
        this.start();
    }

    public void build() throws ConfigException {
        try {
            this._amberManager.init();
            this._entityCache = new LruCache(this._entityCacheSize);
            this._protocolManager.init();
            this._ejbConfig.configure();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public void start() throws Exception {
        this._ejbConfig.deploy();
        for (AbstractServer server : this._serverMap.values()) {
            server.start();
        }
    }

    public AmberEntityHome getAmberEntityHome(String name) {
        return this._amberManager.getEntityHome(name);
    }

    public AmberManager getAmberManager() {
        return this._amberManager;
    }

    public void invalidateCache() {
    }

    public void addServer(AbstractServer server) {
        this._serverMap.put(server.getEJBName(), server);
        try {
            this._protocolManager.addServer(server);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public AbstractServer getServer(String serverId) {
        if (serverId.startsWith("/")) {
            return this._serverMap.get(serverId);
        }
        return this._serverMap.get(new StringBuffer().append("/").append(serverId).toString());
    }

    public AbstractServer getServerByEJBName(String ejbName) {
        if (!ejbName.startsWith("/")) {
            ejbName = new StringBuffer().append("/").append(ejbName).toString();
        }
        return this._serverMap.get(ejbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QEntityContext getEntity(EntityServer server, Object key) {
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            return this._entityCache.get(this._entityKey);
        }
    }

    public QEntityContext putEntityIfNew(EntityServer server, Object key, QEntityContext context) {
        return this._entityCache.putIfNew(new EntityKey(server, key), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(EntityServer server, Object key) {
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(server, key);
            this._entityCache.remove(this._entityKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeans(ArrayList<QEntityContext> beans, EntityServer server) {
        LruCache<EntityKey, QEntityContext> lruCache = this._entityCache;
        synchronized (lruCache) {
            Iterator<LruCache.Entry<EntityKey, QEntityContext>> iter = this._entityCache.iterator();
            while (iter.hasNext()) {
                LruCache.Entry<EntityKey, QEntityContext> entry = iter.next();
                beans.add(entry.getValue());
                iter.remove();
            }
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<AbstractServer> servers = new ArrayList<AbstractServer>(this._serverMap.values());
        this._serverMap.clear();
        Collections.sort(servers, new ServerCmp());
        for (AbstractServer server : servers) {
            try {
                this._protocolManager.removeServer(server);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        for (AbstractServer server : servers) {
            try {
                server.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        this._serverMap = null;
        this._ejbConfig = null;
        this._protocolManager.destroy();
        this._protocolManager = null;
        this._ejbTransactionManager.destroy();
        this._ejbTransactionManager = null;
        this._amberManager.destroy();
        this._amberManager = null;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ServerCmp
    implements Comparator<AbstractServer> {
        ServerCmp() {
        }

        @Override
        public int compare(AbstractServer a, AbstractServer b) {
            return a.getEJBName().compareTo(b.getEJBName());
        }
    }
}

