/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.sql.QueryContext;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;

public class UniqueSingleColumnConstraint
extends Constraint {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/table/UniqueSingleColumnConstraint"));
    private final Column _uniqueColumn;

    public UniqueSingleColumnConstraint(Column column) {
        this._uniqueColumn = column;
    }

    public void validate(TableIterator[] sourceRows, QueryContext queryContext, Transaction xa) throws SQLException {
        TableIterator sourceRow = sourceRows[0];
        Object value = null;
        Table table = sourceRow.getTable();
        TableIterator iter = table.createTableIterator();
        byte[] sourceBuffer = sourceRow.getBuffer();
        int sourceOffset = sourceRow.getRowOffset();
        Column column = this._uniqueColumn;
        int columnOffset = column.getColumnOffset();
        iter.init(queryContext);
        try {
            while (iter.next()) {
                byte[] iterBuffer = iter.getBuffer();
                iter.prevRow();
                while (iter.nextRow()) {
                    int iterOffset = iter.getRowOffset();
                    if (iterBuffer == sourceBuffer && iterOffset == sourceOffset || !column.isEqual(iterBuffer, iterOffset, sourceBuffer, sourceOffset)) continue;
                    throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", column.getString(iterBuffer, iterOffset), table.getName(), column.getName()));
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }
}

