/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.table.Column;

class Row {
    private Column[] _columns = new Column[0];
    private int _rowLength = 1;
    private int _nullOffset = 0;

    Row() {
    }

    int getLength() {
        return this._rowLength;
    }

    int getNullOffset() {
        return this._nullOffset;
    }

    byte getNullMask() {
        return (byte)(1 << (this._columns.length + 1) % 8);
    }

    Column[] getColumns() {
        return this._columns;
    }

    Column getColumn(String name) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!name.equals(this._columns[i].getName())) continue;
            return this._columns[i];
        }
        return null;
    }

    void allocateColumn() {
        if ((this._columns.length + 1) % 8 == 0) {
            this._nullOffset = this._rowLength++;
        }
    }

    Column addColumn(Column column) {
        Column[] newColumns = new Column[this._columns.length + 1];
        System.arraycopy(this._columns, 0, newColumns, 0, this._columns.length);
        this._columns = newColumns;
        this._columns[this._columns.length - 1] = column;
        this._rowLength += column.getLength();
        return column;
    }
}

