/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.store.Lock;
import com.caucho.db.store.WriteBlock;
import com.caucho.db.table.Inode;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.LongKeyHashMap;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Transaction {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/store/Transaction"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/store/Transaction"));
    private static final FreeList<Transaction> _freeList = new FreeList(32);
    private boolean _isAutoCommit = true;
    private ConnectionImpl _conn;
    private ArrayList<Lock> _readLocks = new ArrayList();
    private ArrayList<Lock> _reqWriteLocks = new ArrayList();
    private ArrayList<Lock> _writeLocks = new ArrayList();
    private LongKeyHashMap<WriteBlock> _writeBlocks;
    private ArrayList<Inode> _deleteInodes = new ArrayList();
    private ArrayList<Inode> _addInodes = new ArrayList();
    private boolean _isRollbackOnly;
    private long _timeout = 1000L;

    private Transaction() {
    }

    public static Transaction create(ConnectionImpl conn) {
        Transaction xa = _freeList.allocate();
        if (xa == null) {
            xa = new Transaction();
        }
        xa.init(conn);
        return xa;
    }

    private void init(ConnectionImpl conn) {
        this._conn = conn;
    }

    public void addReadLock(Lock lock) {
        this._readLocks.add(lock);
    }

    public boolean hasReadLock(Lock lock) {
        return this._readLocks.contains(lock);
    }

    public boolean isAutoCommit() {
        return this._isAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._isAutoCommit = autoCommit;
    }

    public void lockRead(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (!this._readLocks.contains(lock)) {
                lock.lockRead(this, this._timeout);
                this._readLocks.add(lock);
            }
        }
        catch (SQLException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public void lockWrite(Lock lock) throws SQLException {
        if (this._isRollbackOnly) {
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (!this._readLocks.contains(lock)) {
                lock.lockRead(this, this._timeout);
                this._readLocks.add(lock);
            }
            if (!this._reqWriteLocks.contains(lock)) {
                lock.lockUpgrade(this, this._timeout);
                this._reqWriteLocks.add(lock);
            }
        }
        catch (SQLException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    public WriteBlock getBlock(long blockId) {
        if (this._writeBlocks == null) {
            return null;
        }
        return this._writeBlocks.get(blockId);
    }

    public void setBlock(WriteBlock block) {
        if (this._writeBlocks == null) {
            this._writeBlocks = new LongKeyHashMap(8);
        }
        this._writeBlocks.put(block.getBlockId(), block);
    }

    public void addDeleteInode(Inode inode) {
        this._deleteInodes.add(inode);
    }

    public void addAddInode(Inode inode) {
        this._addInodes.add(inode);
    }

    public void autoCommit() throws SQLException {
        if (this._isAutoCommit) {
            ConnectionImpl conn = this._conn;
            this._conn = null;
            if (conn != null) {
                conn.setTransaction(null);
            }
        }
    }

    public void setRollbackOnly() {
        this._isRollbackOnly = true;
        this.releaseLocks();
        this._writeBlocks = null;
    }

    public void setRollbackOnly(SQLException e) {
        this.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            int i;
            LongKeyHashMap<WriteBlock> writeBlocks = this._writeBlocks;
            if (this._reqWriteLocks != null) {
                for (i = 0; i < this._reqWriteLocks.size(); ++i) {
                    Lock lock = this._reqWriteLocks.get(i);
                    lock.lockWrite(this, this._timeout);
                    this._writeLocks.add(lock);
                }
            }
            if (writeBlocks != null) {
                try {
                    Iterator<WriteBlock> blockIter = writeBlocks.valueIterator();
                    while (blockIter.hasNext()) {
                        WriteBlock block = blockIter.next();
                        block.write();
                    }
                }
                catch (IOException e) {
                    throw new SQLExceptionWrapper(e);
                }
            }
            for (i = 0; i < this._deleteInodes.size(); ++i) {
                Inode inode = this._deleteInodes.get(i);
                inode.delete();
            }
        }
        finally {
            this.releaseLocks();
            this.close();
        }
    }

    public void rollback() throws SQLException {
        this.releaseLocks();
        this.close();
    }

    private void releaseLocks() {
        Lock lock;
        int i;
        if (this._writeLocks != null) {
            for (i = 0; i < this._writeLocks.size(); ++i) {
                lock = this._writeLocks.get(i);
                try {
                    lock.unlockWrite();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            for (i = 0; i < this._reqWriteLocks.size(); ++i) {
                lock = this._reqWriteLocks.get(i);
                try {
                    if (this._writeLocks.contains(lock)) continue;
                    lock.unlockUpgrade();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._writeLocks.clear();
            this._reqWriteLocks.clear();
        }
        if (this._readLocks != null) {
            for (i = 0; i < this._readLocks.size(); ++i) {
                lock = this._readLocks.get(i);
                try {
                    lock.unlockRead();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._readLocks.clear();
        }
        this._deleteInodes.clear();
        this._addInodes.clear();
    }

    void close() {
        if (this._readLocks != null) {
            this._readLocks.clear();
        }
        if (this._reqWriteLocks != null) {
            this._reqWriteLocks.clear();
        }
        if (this._writeLocks != null) {
            this._writeLocks.clear();
        }
        LongKeyHashMap<WriteBlock> writeBlocks = this._writeBlocks;
        this._writeBlocks = null;
        if (writeBlocks != null) {
            Iterator<WriteBlock> blockIter = writeBlocks.valueIterator();
            while (blockIter.hasNext()) {
                WriteBlock block = blockIter.next();
                block.destroy();
            }
        }
        this._deleteInodes.clear();
        this._addInodes.clear();
        this._isRollbackOnly = false;
        _freeList.free(this);
    }
}

