/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.store;

import com.caucho.db.store.Lock;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.caucho.util.ClockCacheItem;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;

public class Block
implements ClockCacheItem {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/store/Block"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/store/Block"));
    private static final FreeList<byte[]> _freeBuffers = new FreeList(16);
    private Store _store;
    private long _blockId;
    private byte[] _buffer;
    private int _useCount;
    private boolean _isValid;
    private volatile boolean _isUsed;
    private final Lock _lock;

    Block(Store store, long blockId, Lock lock) {
        this._store = store;
        this._blockId = blockId;
        this._buffer = _freeBuffers.allocate();
        if (this._buffer == null) {
            this._buffer = new byte[65536];
        }
        if (lock == null) {
            lock = new Lock(blockId);
        }
        this._lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean allocate() {
        Block block = this;
        synchronized (block) {
            if (this._buffer == null) {
                return false;
            }
            ++this._useCount;
        }
        return true;
    }

    Store getStore() {
        return this._store;
    }

    public long getBlockId() {
        return this._blockId;
    }

    public byte[] getBuffer() {
        return this._buffer;
    }

    public Lock getLock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        Block block = this;
        synchronized (block) {
            if (!this._isValid) {
                this._store.readBlock(this._blockId & 0xFFFFFFFFFFFF0000L, this._buffer, 0, 65536);
                this._isValid = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Block block = this;
        synchronized (block) {
            this._store.writeBlock(this._blockId & 0xFFFFFFFFFFFF0000L, this._buffer, 0, 65536);
            this._isValid = true;
        }
    }

    public void invalidate() {
        this._isValid = false;
    }

    void validate() {
        this._isValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        Block block = this;
        synchronized (block) {
            --this._useCount;
        }
    }

    public boolean isUsed() {
        return this._isUsed || this._useCount > 0;
    }

    public void setUsed() {
        this._isUsed = true;
    }

    public void clearUsed() {
        this._isUsed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent() {
        byte[] buffer;
        Block block = this;
        synchronized (block) {
            buffer = this._buffer;
            this._buffer = null;
        }
        if (buffer != null) {
            _freeBuffers.free(buffer);
        }
    }
}

