/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.GroupResultExpr;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Logger;

class SelectQuery
extends Query {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/SelectQuery"));
    private Expr[] _results;
    private String[] _resultNames;
    private boolean[] _groupFields;
    private Order _order;

    SelectQuery(String sql) throws SQLException {
        super(sql);
    }

    SelectQuery(String sql, FromItem[] fromItems) throws SQLException {
        super(sql, fromItems);
    }

    void setResults(Expr[] resultExprs) throws SQLException {
        this._results = new Expr[resultExprs.length];
        for (int i = 0; i < resultExprs.length; ++i) {
            this._results[i] = resultExprs[i];
        }
        this.setDataFields(resultExprs.length);
    }

    Expr[] getResults() {
        return this._results;
    }

    public void setGroupResult(int index) {
        if (this._groupFields == null) {
            this._groupFields = new boolean[this._results.length];
        }
        this._groupFields[index] = true;
    }

    protected void bind() throws SQLException {
        int i;
        super.bind();
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        if (this.isGroup()) {
            for (i = 0; i < this._results.length; ++i) {
                if (!this.isGroup() || this._results[i] instanceof GroupExpr) continue;
                this._results[i] = new GroupResultExpr(i, this._results[i]);
            }
        }
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        this._resultNames = new String[this._results.length];
        for (i = 0; i < this._resultNames.length; ++i) {
            this._resultNames[i] = this._results[i].getName();
        }
    }

    void setOrder(Order order) {
        this._order = order;
    }

    public boolean isSelect() {
        return true;
    }

    Class getType() {
        if (this._results.length == 1) {
            return this._results[0].getType();
        }
        return ClassLiteral.getClass((String)"java/lang/Object");
    }

    public void execute(QueryContext context, Transaction xa) throws SQLException {
        SelectResult result = SelectResult.create(this._results, this._order);
        try {
            TableIterator[] rows = result.initRows(this.getFromItems());
            context.init(xa, rows);
            if (this.isGroup()) {
                this.executeGroup(result, rows, context, xa);
            } else {
                this.execute(result, rows, context, xa);
            }
            result.initRead();
            context.setResult(result);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
        finally {
            if (xa.isAutoCommit()) {
                xa.commit();
            }
        }
    }

    private void execute(SelectResult result, TableIterator[] rows, QueryContext context, Transaction transaction) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        if (this.start(rows, rowLength, context, transaction)) {
            do {
                result.startRow();
                for (int i = 0; i < this._results.length; ++i) {
                    this._results[i].evalToResult(context, result);
                }
            } while (this.nextTuple(rows, rowLength, context, transaction));
        }
    }

    private void executeGroup(SelectResult result, TableIterator[] rows, QueryContext context, Transaction transaction) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        Expr[] results = this._results;
        int resultsLength = results.length;
        if (this._groupFields == null) {
            this._groupFields = new boolean[0];
        }
        boolean[] groupByFields = this._groupFields;
        int groupByLength = this._groupFields.length;
        if (this.start(rows, rowLength, context, transaction)) {
            do {
                int i;
                context.initGroup(this.getDataFields(), this._groupFields);
                for (i = 0; i < groupByLength; ++i) {
                    if (!groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
                context.selectGroup();
                for (i = 0; i < resultsLength; ++i) {
                    if (i < groupByLength && groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
            } while (this.nextTuple(rows, rowLength, context, transaction));
        }
        Iterator<GroupItem> groupIter = context.groupResults();
        while (groupIter.hasNext()) {
            GroupItem item = groupIter.next();
            context.setGroupItem(item);
            result.startRow();
            for (int i = 0; i < results.length; ++i) {
                results[i].evalToResult(context, result);
            }
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("SelectQuery[");
        cb.append("SELECT ");
        for (int i = 0; i < this._results.length; ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(this._results[i]);
        }
        cb.append(" FROM ");
        FromItem[] fromItems = this.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append(fromItems[i]);
        }
        if (this._whereExpr != null) {
            cb.append(" WHERE " + this._whereExpr);
        }
        cb.append("]");
        return cb.close();
    }
}

