/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Data;
import com.caucho.log.Log;
import com.caucho.util.FreeList;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

class GroupItem {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/GroupItem"));
    private static FreeList<GroupItem> _freeList = new FreeList(256);
    private Data[] _data;
    private boolean[] _isGroupByFields;

    private GroupItem(int size) {
        this._data = new Data[size];
        for (int i = 0; i < size; ++i) {
            this._data[i] = new Data();
        }
    }

    static GroupItem allocate(boolean[] isGroupByFields) {
        GroupItem item = _freeList.allocate();
        if (item == null) {
            item = new GroupItem(isGroupByFields.length);
        }
        item.setSize(isGroupByFields.length);
        item.setGroupByFields(isGroupByFields);
        return item;
    }

    GroupItem allocateCopy() {
        GroupItem item = _freeList.allocate();
        if (item == null) {
            item = new GroupItem(this._data.length);
        }
        item.setSize(this._isGroupByFields.length);
        item.setGroupByFields(this._isGroupByFields);
        for (int i = 0; i < this._isGroupByFields.length; ++i) {
            if (!this._isGroupByFields[i]) continue;
            this.getData(i).copyTo(item.getData(i));
        }
        return item;
    }

    public void init(int size, boolean[] isGroupByFields) {
        this.setSize(size);
        this.setGroupByFields(isGroupByFields);
        this.clear();
    }

    private void setSize(int size) {
        if (this._data.length < size) {
            this._data = new Data[size];
            for (int i = 0; i < size; ++i) {
                this._data[i] = new Data();
            }
        }
    }

    private void setGroupByFields(boolean[] isGroupByFields) {
        this._isGroupByFields = isGroupByFields;
    }

    public void clear() {
        int length = this._data.length;
        for (int i = 0; i < length; ++i) {
            this._data[i].clear();
        }
    }

    public boolean isNull(int index) {
        return this._data[index].isNull();
    }

    public void setDouble(int index, double value) {
        this._data[index].setDouble(value);
    }

    public double getDouble(int index) {
        return this._data[index].getDouble();
    }

    public void setLong(int index, long value) {
        this._data[index].setLong(value);
    }

    public long getLong(int index) {
        return this._data[index].getLong();
    }

    public void setString(int index, String value) {
        this._data[index].setString(value);
    }

    public String getString(int index) {
        return this._data[index].getString();
    }

    public Data getData(int index) {
        return this._data[index];
    }

    public int hashCode() {
        int hash = 37;
        boolean[] isGroupByFields = this._isGroupByFields;
        int length = isGroupByFields.length;
        if (length == 0) {
            return hash;
        }
        Data[] data = this._data;
        for (int i = 0; i < length; ++i) {
            if (!isGroupByFields[i]) continue;
            hash = hash * 65521 + data[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        GroupItem item = (GroupItem)o;
        boolean[] isGroupByFields = this._isGroupByFields;
        if (isGroupByFields != item._isGroupByFields) {
            return false;
        }
        for (int i = 0; i < isGroupByFields.length; ++i) {
            if (!isGroupByFields[i] || this._data[i].equals(item._data[i])) continue;
            return false;
        }
        return true;
    }
}

