/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.el.EL;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.servlet.jsp.el.ELException;

public class ResinType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/ResinType"));
    private String _signature;
    private String _className;
    private ArrayList<String> _args = new ArrayList();
    private int _index;

    public String getSignature() {
        return this._signature;
    }

    public String getClassName() {
        return this._className;
    }

    public void addText(String value) {
        this._signature = value;
    }

    public void init() throws ConfigException {
        if (this._signature == null) {
            throw new ConfigException(L.l("A Signature requires the method signature."));
        }
        this.parseSignature();
    }

    public Object create(Class targetClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigException, InvocationTargetException, ELException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> cl = Class.forName(this._className, false, loader);
        if (targetClass != null && !targetClass.isAssignableFrom(cl)) {
            throw new ConfigException(L.l("{0} is not assignable to {1}", (Object)targetClass.getName(), this._className));
        }
        Constructor constructor = this.getConstructor(cl);
        if (constructor == null) {
            throw new ConfigException(L.l("Can't find a matching public constructor for '{0}'", this._signature));
        }
        Object[] args = new Object[this._args.size()];
        for (int i = 0; i < args.length; ++i) {
            String arg = this._args.get(i);
            args[i] = EL.evalObject(arg);
        }
        return constructor.newInstance(args);
    }

    private Constructor getConstructor(Class cl) {
        Constructor<?>[] cons = cl.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            if (!Modifier.isPublic(cons[i].getModifiers()) || cons[i].getParameterTypes().length != this._args.size()) continue;
            return cons[i];
        }
        return null;
    }

    private void parseSignature() throws ConfigException {
        this._index = 0;
        this._className = this.parseType(this.skipWhitespace(this.read()));
        CharBuffer cb = CharBuffer.allocate();
        int ch = this.skipWhitespace(this.read());
        if (ch < 0) {
            return;
        }
        if (ch != 40) {
            throw new ConfigException(L.l("constructor syntax is `className(arg1, ..., argn)' in `{0}'", this._signature));
        }
        ch = this.skipWhitespace(this.read());
        while (ch > 0 && ch != 41) {
            cb.clear();
            while (ch > 0 && ch != 44 && ch != 41) {
                cb.append((char)ch);
                if (ch == 39 || ch == 34) {
                    int end = ch;
                    ch = this.read();
                    while (ch > 0 && ch != end) {
                        cb.append((char)ch);
                        ch = this.read();
                    }
                    if (ch > 0) {
                        cb.append((char)ch);
                    }
                }
                ch = this.read();
            }
            this._args.add(cb.toString());
        }
        if (ch != 41) {
            throw new ConfigException(L.l("constructor syntax is `className(arg1, ..., argn)' in `{0}'", this._signature));
        }
        ch = this.skipWhitespace(this.read());
        if (ch > 0) {
            throw new ConfigException(L.l("constructor syntax is `className(arg1, ..., argn)' in `{0}'", this._signature));
        }
    }

    private String parseType(int ch) throws ConfigException {
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch) || ch == 46) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (cb.length() == 0) {
            throw new ConfigException(L.l("unexpected empty type in `{0}'", this._signature));
        }
        while (true) {
            if (Character.isWhitespace((char)ch)) {
                ch = this.read();
                continue;
            }
            if (ch != 91) break;
            ch = this.read();
            if (ch != 93) {
                throw new ConfigException(L.l("function syntax is `ret-type name(arg1, ..., argn)' in `{0}'", this._signature));
            }
            cb.append("[]");
            ch = this.read();
        }
        String className = cb.toString();
        this.unread(ch);
        return className;
    }

    private int skipWhitespace(int ch) {
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this._index < this._signature.length()) {
            return this._signature.charAt(this._index++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._index;
        }
    }
}

