/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.types.PathPatternType;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetType {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/PathPatternType"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/types/PathPatternType"));
    private Path _dir;
    private ArrayList<PathPatternType> _includeList;
    private ArrayList<PathPatternType> _excludeList = new ArrayList();

    public void setDir(Path dir) {
        this._dir = dir;
    }

    public Path getDir() {
        return this._dir;
    }

    public void addInclude(PathPatternType pattern) {
        if (this._includeList == null) {
            this._includeList = new ArrayList();
        }
        this._includeList.add(pattern);
    }

    public void addExclude(PathPatternType pattern) {
        this._excludeList.add(pattern);
    }

    public void init() throws ConfigException {
        if (this._dir == null) {
            this._dir = Vfs.lookup();
        }
    }

    public ArrayList<Path> getPaths() {
        return this.getPaths(new ArrayList<Path>());
    }

    public ArrayList<Path> getPaths(ArrayList<Path> paths) {
        String dirPath = this._dir.getPath();
        if (!dirPath.endsWith("/")) {
            dirPath = new StringBuffer().append(dirPath).append("/").toString();
        }
        this.getPaths(paths, dirPath, this._dir);
        return paths;
    }

    public void getPaths(ArrayList<Path> paths, String prefix, Path path) {
        if (path.isDirectory()) {
            try {
                String[] list = path.list();
                for (int i = 0; i < list.length; ++i) {
                    this.getPaths(paths, prefix, path.lookup(list[i]));
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        } else if (path.canRead()) {
            PathPatternType pattern;
            int i;
            String suffix = "";
            String fullPath = path.getPath();
            if (prefix.length() < fullPath.length()) {
                suffix = path.getPath().substring(prefix.length());
            }
            for (i = 0; i < this._excludeList.size(); ++i) {
                pattern = this._excludeList.get(i);
                if (!pattern.isMatch(suffix)) continue;
                return;
            }
            if (this._includeList == null) {
                paths.add(path);
                return;
            }
            for (i = 0; i < this._includeList.size(); ++i) {
                pattern = this._includeList.get(i);
                if (!pattern.isMatch(suffix)) continue;
                paths.add(path);
                return;
            }
        }
    }
}

