/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.regex.Pattern;

public class CronType {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/CronType"));
    private static final long DAY = 86400000L;
    private final QDate _localCalendar = QDate.createLocal();
    private boolean[] _minutes;
    private boolean[] _hours;
    private boolean[] _days;
    private boolean[] _months;
    private boolean[] _daysOfWeek;

    public void addText(String text) throws ConfigException {
        text = text.trim();
        String[] split = Pattern.compile("\\s+").split(text);
        if (split.length > 0) {
            this._minutes = this.parseRange(split[0], 0, 59);
        }
        this._hours = split.length > 1 ? this.parseRange(split[1], 0, 23) : this.parseRange("*", 0, 23);
        if (split.length > 2) {
            this._days = this.parseRange(split[2], 1, 31);
        }
        if (split.length > 3) {
            this._months = this.parseRange(split[3], 1, 12);
        }
        if (split.length > 4) {
            this._daysOfWeek = this.parseRange(split[4], 0, 7);
        }
    }

    private boolean[] parseRange(String range, int rangeMin, int rangeMax) throws ConfigException {
        boolean[] values = new boolean[rangeMax + 1];
        int j = 0;
        while (j < range.length()) {
            char ch = range.charAt(j);
            int min = 0;
            int max = 0;
            int step = 1;
            if (ch == '*') {
                min = rangeMin;
                max = rangeMax;
                ++j;
            } else if ('0' <= ch && ch <= '9') {
                while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                    min = 10 * min + ch - 48;
                    ++j;
                }
                if (j < range.length() && ch == '-') {
                    ++j;
                    while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                        max = 10 * max + ch - 48;
                        ++j;
                    }
                } else {
                    max = min;
                }
            } else {
                throw new ConfigException(L.l("`{0}' is an illegal cron range", range));
            }
            if (min < rangeMin) {
                throw new ConfigException(L.l("`{0}' is an illegal cron range (min value is too small)", range));
            }
            if (rangeMax < max) {
                throw new ConfigException(L.l("`{0}' is an illegal cron range (max value is too large)", range));
            }
            if (j < range.length() && (ch = range.charAt(j)) == '/') {
                step = 0;
                ++j;
                while (j < range.length() && '0' <= (ch = range.charAt(j)) && ch <= '9') {
                    step = 10 * step + ch - 48;
                    ++j;
                }
                if (step == 0) {
                    throw new ConfigException(L.l("`{0}' is an illegal cron range", range));
                }
            }
            if (range.length() > j) {
                if (ch == ',') {
                    ++j;
                } else {
                    throw new ConfigException(L.l("`{0}' is an illegal cron range", range));
                }
            }
            while (min <= max) {
                values[min] = true;
                min += step;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextTime(long now) {
        QDate cal = this._localCalendar;
        now = now + 60000L - now % 60000L;
        QDate qDate = cal;
        synchronized (qDate) {
            int hour;
            cal.setGMTTime(now);
            int minute = this.nextInterval(this._minutes, cal.getMinute());
            if (minute < 0) {
                minute = this.nextInterval(this._minutes, 0);
                cal.setHour(cal.getHour() + 1);
            }
            if ((hour = this.nextInterval(this._hours, cal.getHour())) < 0) {
                hour = this.nextInterval(this._hours, 0);
                minute = this.nextInterval(this._minutes, 0);
                cal.setDayOfMonth(cal.getDayOfMonth() + 1);
            }
            int day = cal.getDayOfMonth();
            if (this._days != null && (day = this.nextInterval(this._days, cal.getDayOfMonth())) < 0) {
                cal.setMonth(cal.getMonth() + 1);
                cal.setDayOfMonth(1);
                day = this.nextInterval(this._days, cal.getDayOfMonth());
                hour = this.nextInterval(this._hours, 0);
                minute = this.nextInterval(this._minutes, 0);
            }
            if (this._daysOfWeek != null) {
                int oldDayOfWeek = cal.getDayOfWeek();
                int dayOfWeek = this.nextInterval(this._daysOfWeek, oldDayOfWeek);
                if (dayOfWeek > 0) {
                    day += dayOfWeek - oldDayOfWeek;
                } else {
                    dayOfWeek = this.nextInterval(this._daysOfWeek, 0);
                    day += dayOfWeek - oldDayOfWeek + 7;
                }
            }
            int month = cal.getMonth();
            int year = (int)cal.getYear();
            return this.nextTime(year, month, day, hour, minute);
        }
    }

    private long nextTime(int year, int month, int day, int hour, int minute) {
        QDate cal = this._localCalendar;
        cal.setLocalTime(0L);
        cal.setYear(year);
        cal.setMonth(month);
        cal.setDayOfMonth(day);
        cal.setHour(hour);
        cal.setMinute(minute);
        return cal.getGMTTime();
    }

    public int nextInterval(boolean[] values, int now) {
        while (now < values.length) {
            if (values[now]) {
                return now;
            }
            ++now;
        }
        return -1;
    }
}

