/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.BuilderProgram;
import com.caucho.config.ConfigException;
import com.caucho.config.j2ee.JndiFieldInjectProgram;
import com.caucho.config.j2ee.JndiInjectProgram;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Inject;
import javax.ejb.Resource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectIntrospector {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/j2ee/InjectIntrospector"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/j2ee/InjectIntrospector"));
    private static Class _injectClass;
    private static Class _resourceClass;
    private static Class _ejbClass;

    public static void configure(Object obj) throws Throwable {
        if (obj != null) {
            for (BuilderProgram program : InjectIntrospector.introspect(obj.getClass())) {
                program.configure(obj);
            }
        }
    }

    public static ArrayList<BuilderProgram> introspect(Class type) throws ConfigException {
        ArrayList<BuilderProgram> initList = new ArrayList<BuilderProgram>();
        try {
            InjectIntrospector.introspectImpl(initList, type);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Error error) {
            // empty catch block
        }
        return initList;
    }

    private static void introspectImpl(ArrayList<BuilderProgram> initList, Class type) throws ConfigException, ClassNotFoundException {
        _injectClass = Class.forName("javax.ejb.Inject");
        _resourceClass = Class.forName("javax.ejb.Resource");
        _ejbClass = Class.forName("javax.ejb.EJB");
        for (Field field : type.getDeclaredFields()) {
            InjectIntrospector.configure(initList, field, field.getName(), field.getType());
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            char ch;
            String fieldName = ((Method)accessibleObject).getName();
            Class<?>[] param = ((Method)accessibleObject).getParameterTypes();
            if (param.length != 1) continue;
            if (fieldName.startsWith("set") && fieldName.length() > 3 && Character.isUpperCase(ch = (fieldName = fieldName.substring(3)).charAt(0)) && (fieldName.length() == 1 || Character.isLowerCase(fieldName.charAt(1)))) {
                fieldName = new StringBuffer().append(Character.toLowerCase(ch)).append(fieldName.substring(1)).toString();
            }
            InjectIntrospector.configure(initList, accessibleObject, fieldName, param[0]);
        }
    }

    private static void configure(ArrayList<BuilderProgram> initList, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        if (field.isAnnotationPresent(_injectClass)) {
            InjectIntrospector.configureInject(initList, field, fieldName, fieldType);
        } else if (field.isAnnotationPresent(_resourceClass)) {
            InjectIntrospector.configureResource(initList, field, fieldName, fieldType);
        } else if (field.isAnnotationPresent(_ejbClass)) {
            InjectIntrospector.configureEJB(initList, field, fieldName, fieldType);
        }
    }

    private static void configureResource(ArrayList<BuilderProgram> initList, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        Resource resource = (Resource)field.getAnnotation(_resourceClass);
        InjectIntrospector.configureResource(initList, field, fieldName, fieldType, resource.name(), resource.resourceType(), resource.jndiName());
    }

    private static void configureInject(ArrayList<BuilderProgram> initList, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        Inject inject = (Inject)field.getAnnotation(_injectClass);
        InjectIntrospector.configureResource(initList, field, fieldName, fieldType, "", "", inject.jndiName());
    }

    private static void configureEJB(ArrayList<BuilderProgram> initList, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        EJB ejb = (EJB)field.getAnnotation(_ejbClass);
        InjectIntrospector.configureResource(initList, field, fieldName, fieldType, ejb.name(), "javax.ejb.EJBLocalObject", ejb.jndiName());
    }

    private static void configureResource(ArrayList<BuilderProgram> initList, AccessibleObject field, String fieldName, Class fieldType, String name, String resourceType, String jndiName) throws ConfigException {
        String prefix = "";
        if (name.equals("")) {
            name = fieldName;
        }
        if (resourceType.equals("")) {
            resourceType = fieldType.getName();
        }
        if (resourceType.equals("javax.sql.DataSource")) {
            prefix = "jdbc/";
        } else if (resourceType.startsWith("javax.jms.")) {
            prefix = "jms/";
        } else if (resourceType.startsWith("javax.mail.")) {
            prefix = "mail/";
        } else if (resourceType.equals("java.net.URL")) {
            prefix = "url/";
        } else if (resourceType.startsWith("javax.ejb.")) {
            prefix = "ejb/";
        }
        if (jndiName.equals("")) {
            jndiName = "javax.transaction.UserTransaction".equals(resourceType) ? "java:comp/UserTransaction" : ("javax.ejb.EntityManager".equals(resourceType) ? "java:comp/EntityManager" : name);
        }
        int colon = jndiName.indexOf(58);
        int slash = jndiName.indexOf(47);
        if (colon < 0 || slash > 0 && slash < colon) {
            jndiName = new StringBuffer().append("java:comp/env/").append(prefix).append(jndiName).toString();
        }
        if (field instanceof Method) {
            initList.add(new JndiInjectProgram(jndiName, (Method)field));
        } else {
            initList.add(new JndiFieldInjectProgram(jndiName, (Field)field));
        }
    }
}

