/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.config.SchemaBean;
import com.caucho.config.core.ResinControl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.xml.LooseXml;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import org.iso_relax.verifier.Schema;
import org.w3c.dom.Document;

public class ResinInclude
extends ResinControl {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/core/ResinInclude"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/core/ResinInclude"));
    private Path _path;
    private boolean _isOptional = true;
    private String _systemId;

    public void setConfigSystemId(String systemId) {
        this._systemId = systemId;
    }

    public void setHref(String path) {
        this._path = this._systemId != null ? Vfs.lookup().lookup(this._systemId).getParent().lookup(path) : Vfs.lookup().lookup(path);
    }

    public void setPath(String path) {
        this.setHref(path);
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public void init() throws Exception {
        if (this._path == null) {
            throw new ConfigException(L.l("'href' attribute missing from resin:include."));
        }
        if (!this._path.canRead() || this._path.isDirectory()) {
            throw new ConfigException(L.l("Required file '{0}' can not be read for resin:include.", this._path.getNativePath()));
        }
        Object object = this.getObject();
        NodeBuilder builder = new NodeBuilder();
        if (object instanceof SchemaBean) {
            Schema schema = ((SchemaBean)object).getSchema();
            builder.setSchema(schema);
        }
        log.config(L.l("resin:include '{0}'", this._path.getNativePath()));
        LooseXml xml = new LooseXml();
        Document doc = xml.parseDocument(this._path);
        NodeBuilder.configure(object, doc);
    }
}

