/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.BeanBuilderException;
import com.caucho.config.types.RawString;
import com.caucho.util.CauchoSystem;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;

public class PrimitivePropertyBuilder
extends AttributeBuilder {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/PrimitivePropertyBuilder"));
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CHARACTER = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int STRING = 9;
    public static final int RAW_STRING = 10;
    public static final int CLASS = 11;
    public static final int BOOLEAN_OBJECT = 101;
    public static final int BYTE_OBJECT = 102;
    public static final int CHARACTER_OBJECT = 103;
    public static final int SHORT_OBJECT = 104;
    public static final int INTEGER_OBJECT = 105;
    public static final int LONG_OBJECT = 106;
    public static final int FLOAT_OBJECT = 107;
    public static final int DOUBLE_OBJECT = 108;
    private static final IntMap _acceptedTypes = new IntMap();
    private final Method _setter;
    private final int _builder;
    private String _name;

    public PrimitivePropertyBuilder(Method setter, String name, Class type) throws BeanBuilderException {
        if (!PrimitivePropertyBuilder.accepts(type)) {
            throw new BeanBuilderException(L.l("Unsupported type: `{0}'.", type.getName()));
        }
        this._setter = setter;
        this._name = name;
        this._builder = _acceptedTypes.get(type);
    }

    public boolean isPrimitive() {
        return true;
    }

    public void setString(Object bean, String value) throws BeanBuilderException {
        try {
            if (value == null) {
                this.setNull(bean);
                return;
            }
            switch (this._builder) {
                case 1: 
                case 101: {
                    this._setter.invoke(bean, this._name, new Boolean(PrimitivePropertyBuilder.evalBoolean(value)));
                    break;
                }
                case 2: 
                case 102: {
                    this._setter.invoke(bean, this._name, new Byte((byte)PrimitivePropertyBuilder.evalLong(value)));
                    break;
                }
                case 3: 
                case 103: {
                    value = PrimitivePropertyBuilder.evalString(value);
                    if (value.length() > 1) {
                        throw new BeanBuilderException(L.l("Can't convert string `{0}' into a character.", value));
                    }
                    this._setter.invoke(bean, this._name, new Character(value.charAt(0)));
                    break;
                }
                case 4: 
                case 104: {
                    this._setter.invoke(bean, this._name, new Short((short)PrimitivePropertyBuilder.evalLong(value)));
                    break;
                }
                case 5: 
                case 105: {
                    this._setter.invoke(bean, this._name, new Integer((int)PrimitivePropertyBuilder.evalLong(value)));
                    break;
                }
                case 6: 
                case 106: {
                    this._setter.invoke(bean, this._name, new Long(PrimitivePropertyBuilder.evalLong(value)));
                    break;
                }
                case 7: 
                case 107: {
                    this._setter.invoke(bean, this._name, new Float((float)PrimitivePropertyBuilder.evalDouble(value)));
                    break;
                }
                case 8: 
                case 108: {
                    this._setter.invoke(bean, this._name, new Double(PrimitivePropertyBuilder.evalDouble(value)));
                    break;
                }
                case 9: {
                    this._setter.invoke(bean, this._name, PrimitivePropertyBuilder.evalString(value));
                    break;
                }
                case 10: {
                    this._setter.invoke(bean, this._name, new RawString(value));
                    break;
                }
                case 11: {
                    this._setter.invoke(bean, this._name, CauchoSystem.loadClass(value));
                    break;
                }
                default: {
                    throw new IllegalStateException(L.l("Shouldn't happen"));
                }
            }
        }
        catch (Exception e) {
            throw new BeanBuilderException(e);
        }
    }

    private void setNull(Object bean) throws Exception {
        switch (this._builder) {
            case 1: {
                this._setter.invoke(bean, this._name, Boolean.TRUE);
                break;
            }
            case 2: {
                this._setter.invoke(bean, this._name, new Byte(0));
                break;
            }
            case 3: {
                this._setter.invoke(bean, this._name, new Character('\u0000'));
                break;
            }
            case 4: {
                this._setter.invoke(bean, this._name, new Short(0));
                break;
            }
            case 5: {
                this._setter.invoke(bean, this._name, new Integer(0));
                break;
            }
            case 6: {
                this._setter.invoke(bean, this._name, new Long(0L));
                break;
            }
            case 7: {
                this._setter.invoke(bean, this._name, new Float(0.0f));
                break;
            }
            case 8: {
                this._setter.invoke(bean, this._name, new Double(0.0));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                this._setter.invoke(bean, this._name, null);
                break;
            }
            default: {
                throw new IllegalStateException(L.l("Shouldn't happen"));
            }
        }
    }

    public static boolean accepts(Class type) {
        return _acceptedTypes.get(type) != -65536;
    }

    public String toString() {
        return "PrimitivePropertyBuilder[" + this._name + ",type=" + this.getTypeName() + "]";
    }

    private String getTypeName() {
        switch (this._builder) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "char";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 101: {
                return "Boolean";
            }
            case 102: {
                return "Byte";
            }
            case 104: {
                return "Short";
            }
            case 105: {
                return "Integer";
            }
            case 106: {
                return "Long";
            }
            case 107: {
                return "Float";
            }
            case 108: {
                return "Double";
            }
            case 9: {
                return "String";
            }
            case 10: {
                return "RawString";
            }
            case 11: {
                return "Class";
            }
        }
        return String.valueOf(this._builder);
    }

    static {
        _acceptedTypes.put(Boolean.TYPE, 1);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Boolean"), 101);
        _acceptedTypes.put(Byte.TYPE, 2);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Byte"), 102);
        _acceptedTypes.put(Character.TYPE, 3);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Character"), 103);
        _acceptedTypes.put(Short.TYPE, 4);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Short"), 104);
        _acceptedTypes.put(Integer.TYPE, 5);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Integer"), 105);
        _acceptedTypes.put(Long.TYPE, 6);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Long"), 106);
        _acceptedTypes.put(Float.TYPE, 7);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Float"), 107);
        _acceptedTypes.put(Double.TYPE, 8);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Double"), 108);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/String"), 9);
        _acceptedTypes.put(ClassLiteral.getClass((String)"com/caucho/config/types/RawString"), 10);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Class"), 11);
    }
}

