/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.BeanBuilderException;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrimitiveAttributeBuilder
extends AttributeBuilder {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/PrimitiveAttributeBuilder"));
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/PrimitiveAttributeBuilder"));
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int CHARACTER = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DOUBLE = 8;
    public static final int STRING = 9;
    public static final int CLASS = 10;
    public static final int RAW_STRING = 11;
    public static final int BOOLEAN_OBJECT = 101;
    public static final int BYTE_OBJECT = 102;
    public static final int CHARACTER_OBJECT = 103;
    public static final int SHORT_OBJECT = 104;
    public static final int INTEGER_OBJECT = 105;
    public static final int LONG_OBJECT = 106;
    public static final int FLOAT_OBJECT = 107;
    public static final int DOUBLE_OBJECT = 108;
    private static final IntMap _acceptedTypes = new IntMap();
    private static final HashMap<String, Class> _primClasses = new HashMap();
    private static volatile Object[] _freeArgs;
    private final Method _setter;
    private final int _builder;

    public PrimitiveAttributeBuilder(Method setter, Class type) throws BeanBuilderException {
        if (!PrimitiveAttributeBuilder.accepts(type)) {
            throw new BeanBuilderException(L.l("Unsupported type: `{0}'.", type.getName()));
        }
        if (!Modifier.isPublic(setter.getModifiers())) {
            throw new IllegalStateException(L.l("'{0}' is not public.", setter.toString()));
        }
        this._setter = setter;
        this._builder = _acceptedTypes.get(type);
    }

    public boolean isPrimitive() {
        return true;
    }

    public static boolean isPrimitive(Class cl) {
        return _acceptedTypes.get(cl) >= 0;
    }

    public void setString(Object bean, String value) throws Exception {
        Object objValue;
        if (bean == null) {
            throw new NullPointerException("bean must not be null for " + this._setter);
        }
        if (value == null) {
            this.setNull(bean);
            return;
        }
        switch (this._builder) {
            case 1: 
            case 101: {
                if (value.indexOf("${") >= 0) {
                    objValue = new Boolean(PrimitiveAttributeBuilder.evalBoolean(value));
                    break;
                }
                if (value.equals("false") || value.equals("no")) {
                    objValue = new Boolean(false);
                    break;
                }
                objValue = new Boolean(true);
                break;
            }
            case 2: 
            case 102: {
                objValue = new Byte((byte)PrimitiveAttributeBuilder.evalLong(value));
                break;
            }
            case 3: 
            case 103: {
                objValue = PrimitiveAttributeBuilder.evalString(value);
                if (value.length() > 1) {
                    throw new ConfigException(L.l("Can't convert string `{0}' into a character.", value));
                }
                objValue = new Character(value.charAt(0));
                break;
            }
            case 4: 
            case 104: {
                objValue = new Short((short)PrimitiveAttributeBuilder.evalLong(value));
                break;
            }
            case 5: 
            case 105: {
                objValue = new Integer((int)PrimitiveAttributeBuilder.evalLong(value));
                break;
            }
            case 6: 
            case 106: {
                objValue = new Long(PrimitiveAttributeBuilder.evalLong(value));
                break;
            }
            case 7: 
            case 107: {
                objValue = new Float((float)PrimitiveAttributeBuilder.evalDouble(value));
                break;
            }
            case 8: 
            case 108: {
                objValue = new Double(PrimitiveAttributeBuilder.evalDouble(value));
                break;
            }
            case 9: {
                objValue = PrimitiveAttributeBuilder.evalString(value);
                break;
            }
            case 11: {
                objValue = new RawString(value);
                break;
            }
            case 10: {
                objValue = this.loadClass(value);
                break;
            }
            default: {
                throw new IllegalStateException(L.l("Shouldn't happen"));
            }
        }
        this.invoke(bean, objValue);
    }

    private void setNull(Object bean) throws Exception {
        Object value;
        switch (this._builder) {
            case 1: {
                value = Boolean.TRUE;
                break;
            }
            case 2: {
                value = new Byte(0);
                break;
            }
            case 3: {
                value = new Character('\u0000');
                break;
            }
            case 4: {
                value = new Short(0);
                break;
            }
            case 5: {
                value = new Integer(0);
                break;
            }
            case 6: {
                value = new Long(0L);
                break;
            }
            case 7: {
                value = new Float(0.0f);
                break;
            }
            case 8: {
                value = new Double(0.0);
                break;
            }
            case 10: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                value = null;
                break;
            }
            case 9: {
                value = "";
                break;
            }
            case 11: {
                value = new RawString("");
                break;
            }
            default: {
                throw new IllegalStateException(L.l("Shouldn't happen"));
            }
        }
        this.invoke(bean, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(Object bean, Object value) throws Exception {
        Object[] args;
        Class clazz = ClassLiteral.getClass((String)"com/caucho/config/PrimitiveAttributeBuilder");
        synchronized (clazz) {
            args = _freeArgs;
            _freeArgs = null;
        }
        if (args == null) {
            args = new Object[]{value};
        }
        this._setter.invoke(bean, args);
        _freeArgs = args;
    }

    private Class loadClass(String name) throws ClassNotFoundException, ConfigException {
        Class cl = _primClasses.get(name);
        if (cl != null) {
            return cl;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassNotFoundException e = null;
        try {
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e1) {
            e = e1;
            try {
                return CauchoSystem.loadClass("java.lang." + name, false, loader);
            }
            catch (ClassNotFoundException e12) {
                log.log(Level.FINE, e.toString(), e);
                throw new ConfigException(L.l("Can't load class `{0}' in the current context.\n{1}{2}", name, e, this.getClassPath(loader)));
            }
        }
    }

    private String getClassPath(ClassLoader loader) {
        while (loader != null) {
            String classPath;
            if (loader instanceof DynamicClassLoader && (classPath = ((DynamicClassLoader)loader).getClassPath()) != null) {
                return this.classPathErrorMessage(classPath);
            }
            loader = loader.getParent();
        }
        return "";
    }

    private String classPathErrorMessage(String classPath) {
        CharBuffer cb = new CharBuffer();
        cb.append("\nClassPath:");
        int head = 0;
        while (head < classPath.length()) {
            String segment;
            int tail = classPath.indexOf(File.pathSeparatorChar, head);
            if (tail >= 0) {
                segment = classPath.substring(head, tail);
                head = tail + 1;
            } else {
                segment = classPath.substring(head);
                head = classPath.length();
            }
            cb.append("\n  " + segment);
        }
        return cb.toString();
    }

    public static boolean accepts(Class type) {
        return _acceptedTypes.get(type) != -65536;
    }

    static {
        _acceptedTypes.put(Boolean.TYPE, 1);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Boolean"), 101);
        _acceptedTypes.put(Byte.TYPE, 2);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Byte"), 102);
        _acceptedTypes.put(Character.TYPE, 3);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Character"), 103);
        _acceptedTypes.put(Short.TYPE, 4);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Short"), 104);
        _acceptedTypes.put(Integer.TYPE, 5);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Integer"), 105);
        _acceptedTypes.put(Long.TYPE, 6);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Long"), 106);
        _acceptedTypes.put(Float.TYPE, 7);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Float"), 107);
        _acceptedTypes.put(Double.TYPE, 8);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Double"), 108);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/String"), 9);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Class"), 10);
        _acceptedTypes.put(ClassLiteral.getClass((String)"com/caucho/config/types/RawString"), 11);
        _primClasses.put("boolean", Boolean.TYPE);
        _primClasses.put("byte", Byte.TYPE);
        _primClasses.put("short", Short.TYPE);
        _primClasses.put("char", Character.TYPE);
        _primClasses.put("int", Integer.TYPE);
        _primClasses.put("long", Long.TYPE);
        _primClasses.put("float", Float.TYPE);
        _primClasses.put("double", Double.TYPE);
    }
}

