/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.AttributeBuilder;
import com.caucho.config.BeanBuilderException;
import com.caucho.config.ConfigException;
import com.caucho.config.TypeBuilder;
import com.caucho.config.types.RawString;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class BeanBuilder
extends TypeBuilder {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/config/BeanBuilder"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/BeanBuilder"));
    private static QName ID = new QName("id");
    private static Method NULL_METHOD;
    private boolean _isValid;
    private Method _setParent;
    private Class _parentClass;
    private Method _addText;
    private boolean _isRawText;
    private Method _setLocation;
    private Method _setSystemId;
    private Method _setNode;
    private Method _replaceObject;
    private Method _init;

    public BeanBuilder(Class beanClass) throws ConfigException, BeanBuilderException {
        super(beanClass);
        try {
            this._setLocation = this.findMethod("setConfigLocation", new Class[]{ClassLiteral.getClass((String)"java/lang/String"), Integer.TYPE});
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._setSystemId = this.findMethod("setConfigSystemId", new Class[]{ClassLiteral.getClass((String)"java/lang/String")});
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._setNode = this.findMethod("setConfigNode", new Class[]{ClassLiteral.getClass((String)"org/w3c/dom/Node")});
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._setParent = this.getSetter("parent");
            if (this._setParent != null) {
                this._parentClass = this._setParent.getParameterTypes()[0];
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._replaceObject = this.findMethod("replaceObject", new Class[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this._init = this.findMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setParent(Object obj, Object parent) {
        if (this._setParent != null && parent != null && this._parentClass.isAssignableFrom(parent.getClass())) {
            try {
                this._setParent.invoke(obj, parent);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void setLocation(Object obj, String systemId, String filename, int line) {
        if (this._setLocation != null) {
            try {
                this._setLocation.invoke(obj, filename, new Integer(line));
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._setSystemId != null) {
            try {
                this._setSystemId.invoke(obj, systemId);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void setNode(Object obj, Node node) {
        if (this._setNode != null) {
            try {
                this._setNode.invoke(obj, node);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    boolean hasAddText() {
        if (this._addText == null) {
            this._addText = this.findMethod("addText", new Class[]{ClassLiteral.getClass((String)"java/lang/String")});
        }
        if (this._addText == null) {
            this._addText = this.findMethod("addText", new Class[]{ClassLiteral.getClass((String)"com/caucho/config/types/RawString")});
            this._isRawText = true;
        }
        return this._addText != null;
    }

    public void addText(Object obj, String text) throws Exception {
        AttributeBuilder id = null;
        try {
            id = this.getAttributeBuilder(ID);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (id != null) {
            id.setString(obj, text);
        } else {
            if (this._addText == null) {
                this._addText = this.findMethod("addText", new Class[]{ClassLiteral.getClass((String)"java/lang/String")});
            }
            if (this._addText == null) {
                this._addText = this.findMethod("addText", new Class[]{ClassLiteral.getClass((String)"com/caucho/config/types/RawString")});
                this._isRawText = true;
            }
            if (this._addText != null) {
                if (this._isRawText) {
                    this._addText.invoke(obj, new RawString(text));
                } else {
                    String value = AttributeBuilder.evalString(text);
                    this._addText.invoke(obj, value);
                }
            }
        }
    }

    public Object create() throws Exception {
        if (!this._isValid) {
            BeanBuilder.validateBeanClass(this._type);
            this._isValid = true;
        }
        try {
            return this._type.newInstance();
        }
        catch (Error e) {
            throw new ConfigException(L.l("Can't instantiate '{0}'.\n{1}", (Object)this._type, e), e);
        }
    }

    public void setAttribute(Object bean, String attributeName, Object value) throws ConfigException {
        Method method = this.getSetter(attributeName);
        if (method == null) {
            throw new ConfigException(L.l("Can't find setter for attribute `{0}' in bean class `{1}'.", (Object)attributeName, this._type.getName()));
        }
        Class<?>[] argTypes = method.getParameterTypes();
        if (argTypes.length == 1) {
            BeanBuilder.invokeBeanMethod(bean, method, new Object[]{value});
        } else if (argTypes.length == 2 && ClassLiteral.getClass((String)"java/lang/String").equals(argTypes[0]) && ClassLiteral.getClass((String)"java/lang/String").equals(argTypes[1])) {
            Object[] args = new Object[]{attributeName, value};
            BeanBuilder.invokeBeanMethod(bean, method, args);
        } else {
            throw new ConfigException(L.l("Don't know how to invoke setter `{0}' for attribute `{1}' in bean class `{2}'.", method.toString(), attributeName, this._type.getName()));
        }
    }

    public void init(Object bean) throws Exception {
        if (this._init != null) {
            this._init.invoke(bean, NULL_ARGS);
        }
    }

    public Object replaceObject(Object bean) throws Exception {
        if (this._replaceObject != null) {
            return this._replaceObject.invoke(bean, NULL_ARGS);
        }
        return bean;
    }

    private Method getSetter(String attributeName) {
        Method method = null;
        if (method == null) {
            method = this.findOneArgSetter(attributeName);
        }
        if (method == null) {
            method = this.findSetPropertyMethod();
        }
        return method;
    }

    public static void validateBeanClass(Class beanClass, Class parentClass) throws ConfigException {
        if (!parentClass.isAssignableFrom(beanClass)) {
            throw new ConfigException(L.l("Bean class `{0}' must be assignable to `{1}'.", beanClass.getClass(), parentClass.getClass()));
        }
        BeanBuilder.validateBeanClass(beanClass);
    }

    public static void validateBeanClass(Class beanClass) throws ConfigException {
        if (beanClass == null) {
            throw new ConfigException(L.l("null classes can't be instantiated."));
        }
        if (beanClass.isInterface()) {
            throw new ConfigException(L.l("`{0}' must be a concrete class.  Interfaces cannot be instantiated.", beanClass.getName()));
        }
        if (!Modifier.isPublic(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class `{0}' is not public.  Bean classes must be public, concrete, and have a zero-argument constructor.", beanClass.getName()));
        }
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw new ConfigException(L.l("Custom bean class `{0}' is abstract.  Bean classes must be public, concrete, and have a zero-argument constructor.", beanClass.getName()));
        }
        Constructor<?>[] constructors = beanClass.getDeclaredConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            constructor = constructors[i];
            break;
        }
        if (constructor == null) {
            throw new ConfigException(L.l("Custom bean class `{0}' doesn't have a zero-arg constructor.  Bean classes must be have a zero-argument constructor.", beanClass.getName()));
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new ConfigException(L.l("The zero-argument constructor for `{0}' isn't public.  Bean classes must have a public zero-argument constructor.", beanClass.getName()));
        }
    }

    public String toString() {
        return "BeanBuilder[" + this.getType().getName() + "]";
    }

    private void nullMethod() {
    }

    static {
        try {
            Method[] methods = ClassLiteral.getClass((String)"com/caucho/config/BeanBuilder").getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals("nullMethod")) continue;
                NULL_METHOD = methods[i];
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }
}

