/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.log.Log;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/JavaClass"));
    public static final int MAGIC = -889275714;
    private int _major;
    private int _minor;
    private ConstantPool _constantPool = new ConstantPool();
    private int _accessFlags;
    private String _thisClass;
    private String _superClass;
    private ArrayList<String> _interfaces = new ArrayList();
    private ArrayList<JavaField> _fields = new ArrayList();
    private ArrayList<JavaMethod> _methods = new ArrayList();
    private ArrayList<Attribute> _attributes = new ArrayList();

    public void setMajor(int major) {
        this._major = major;
    }

    public int getMajor() {
        return this._major;
    }

    public void setMinor(int minor) {
        this._minor = minor;
    }

    public int getMinor() {
        return this._minor;
    }

    public ConstantPool getConstantPool() {
        return this._constantPool;
    }

    public void setAccessFlags(int flags) {
        this._accessFlags = flags;
    }

    public int getAccessFlags() {
        return this._accessFlags;
    }

    public void setThisClass(String className) {
        this._thisClass = className;
    }

    public String getThisClass() {
        return this._thisClass;
    }

    public void setSuperClass(String className) {
        this._superClass = className;
        this.getConstantPool().addClass(className);
    }

    public String getSuperClass() {
        return this._superClass;
    }

    public void addInterface(String className) {
        this._interfaces.add(className);
    }

    public ArrayList<String> getInterfaces() {
        return this._interfaces;
    }

    public void addField(JavaField field) {
        this._fields.add(field);
    }

    public ArrayList<JavaField> getFieldList() {
        return this._fields;
    }

    public JavaField getField(String name) {
        for (int i = 0; i < this._fields.size(); ++i) {
            JavaField field = this._fields.get(i);
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public void addMethod(JavaMethod method) {
        this._methods.add(method);
    }

    public ArrayList<JavaMethod> getMethodList() {
        return this._methods;
    }

    public JavaMethod getMethod(String name) {
        for (int i = 0; i < this._methods.size(); ++i) {
            JavaMethod method = this._methods.get(i);
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public JavaMethod findMethod(String name, String descriptor) {
        for (int i = 0; i < this._methods.size(); ++i) {
            JavaMethod method = this._methods.get(i);
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    public void addAttribute(Attribute attr) {
        this._attributes.add(attr);
        attr.addConstants(this);
    }

    public ArrayList<Attribute> getAttributeList() {
        return this._attributes;
    }

    public void write(WriteStream os) throws IOException {
        int i;
        ByteCodeWriter out = new ByteCodeWriter(os, this);
        out.writeInt(-889275714);
        out.writeShort(this._minor);
        out.writeShort(this._major);
        this._constantPool.write(out);
        out.writeShort(this._accessFlags);
        out.writeClass(this._thisClass);
        out.writeClass(this._superClass);
        out.writeShort(this._interfaces.size());
        for (i = 0; i < this._interfaces.size(); ++i) {
            String className = this._interfaces.get(i);
            out.writeClass(className);
        }
        out.writeShort(this._fields.size());
        for (i = 0; i < this._fields.size(); ++i) {
            JavaField field = this._fields.get(i);
            field.write(out);
        }
        out.writeShort(this._methods.size());
        for (i = 0; i < this._methods.size(); ++i) {
            JavaMethod method = this._methods.get(i);
            method.write(out);
        }
        out.writeShort(this._attributes.size());
        for (i = 0; i < this._attributes.size(); ++i) {
            Attribute attr = this._attributes.get(i);
            attr.write(out);
        }
    }

    public String toString() {
        return new StringBuffer().append("JavaClass[").append(this._thisClass).append("]").toString();
    }
}

