/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ExceptionsAttribute
extends Attribute {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/ExceptionsAttribute"));
    private ArrayList<String> _exceptions = new ArrayList();

    ExceptionsAttribute(String name) {
        super(name);
    }

    public void addException(String exn) {
        this._exceptions.add(exn);
    }

    public void read(ByteCodeParser in) throws IOException {
        int length = in.readInt();
        int exnCount = in.readShort();
        for (int i = 0; i < exnCount; ++i) {
            int index = in.readShort();
            if (index == 0) {
                this._exceptions.add(null);
            }
            this._exceptions.add(in.getConstantPool().getClass(index).getName());
        }
    }

    public void write(ByteCodeWriter out) throws IOException {
        out.writeUTF8Const(this.getName());
        TempStream ts = new TempStream();
        ts.openWrite();
        WriteStream ws = new WriteStream(ts);
        ByteCodeWriter o2 = new ByteCodeWriter(ws, out.getJavaClass());
        o2.writeShort(this._exceptions.size());
        for (int i = 0; i < this._exceptions.size(); ++i) {
            String exn = this._exceptions.get(i);
            o2.writeClass(exn);
        }
        ws.close();
        out.writeInt(ts.getLength());
        for (TempBuffer ptr = ts.getHead(); ptr != null; ptr = ptr.getNext()) {
            out.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        ts.destroy();
    }

    public Attribute export(JavaClass cl, JavaClass target) {
        ConstantPool cp = target.getConstantPool();
        cp.addUTF8(this.getName());
        ExceptionsAttribute attr = new ExceptionsAttribute(this.getName());
        for (int i = 0; i < this._exceptions.size(); ++i) {
            String exn = this._exceptions.get(i);
            cp.addClass(exn);
            attr.addException(exn);
        }
        return attr;
    }

    public String toString() {
        return "ExceptionsAttribute[" + this.getName() + "]";
    }
}

