/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class UtilDateType
extends Type {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/UtilDateType"));
    private static final UtilDateType UTIL_DATE_TYPE = new UtilDateType();

    private UtilDateType() {
    }

    public static UtilDateType create() {
        return UTIL_DATE_TYPE;
    }

    public String getName() {
        return "java.util.Date";
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.UtilDateType.toDate(" + rs + ".getTimestamp(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TIMESTAMP);");
        out.println("else");
        out.println("  " + pstmt + ".setTimestamp(" + index + "++, new java.sql.Timestamp(" + value + ".getTime()));");
    }

    public static Date toDate(Timestamp time) throws SQLException {
        return time;
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        Timestamp date = rs.getTimestamp(index);
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }
}

