/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveIntType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveIntType"));
    private static final PrimitiveIntType INT_TYPE = new PrimitiveIntType();

    private PrimitiveIntType() {
    }

    public static PrimitiveIntType create() {
        return INT_TYPE;
    }

    public String getName() {
        return "int";
    }

    public Type getForeignType() {
        return IntegerType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(4, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getInt(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveIntType.toForeignInt(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setInt(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
    }

    public String toObject(String value) {
        return "new Integer(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").intValue()";
    }

    public static Integer toForeignInt(int value, boolean wasNull) {
        if (wasNull || value == 0) {
            return null;
        }
        return new Integer(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        int v = rs.getInt(index);
        return rs.wasNull() ? null : new Integer(v);
    }

    public Object toObject(long value) {
        return new Integer((int)value);
    }
}

