/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

class UnaryExpr
extends AbstractAmberExpr {
    private AmberExpr _expr;
    private int _token;

    UnaryExpr(int token, AmberExpr expr) {
        this._token = token;
        this._expr = expr;
    }

    public boolean isBoolean() {
        return Boolean.TYPE.equals(this.getType());
    }

    public Class getJavaType() {
        switch (this._token) {
            case 139: 
            case 169: {
                return Boolean.TYPE;
            }
        }
        return Double.TYPE;
    }

    public AmberExpr bindSelect(QueryParser parser) {
        this._expr = this._expr.bindSelect(parser);
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        switch (this._token) {
            case 43: 
            case 45: 
            case 139: 
            case 173: {
                return this._expr.usesFrom(from, type);
            }
            case 169: {
                return this._expr.usesFrom(from, type, !isNot);
            }
        }
        return false;
    }

    public void generateWhere(CharBuffer cb) {
        switch (this._token) {
            case 45: {
                cb.append(" -");
                break;
            }
            case 43: {
                cb.append(" +");
                break;
            }
            case 169: {
                cb.append("NOT ");
                break;
            }
            case 139: 
            case 173: {
                if (this._expr instanceof ManyToOneExpr) {
                    ManyToOneExpr path = (ManyToOneExpr)this._expr;
                    cb.append('(');
                    ArrayList<ForeignColumn> keys = path.getLinkColumns().getColumns();
                    for (int i = 0; i < keys.size(); ++i) {
                        if (i != 0) {
                            cb.append(" AND ");
                        }
                        cb.append(path.getFromItem().getName());
                        cb.append(".");
                        cb.append(keys.get(i).getName());
                        if (this._token == 139) {
                            cb.append(" IS NULL");
                            continue;
                        }
                        cb.append(" IS NOT NULL");
                    }
                    cb.append(')');
                } else {
                    this._expr.generateWhere(cb);
                    if (this._token == 139) {
                        cb.append(" IS NULL");
                    } else {
                        cb.append(" IS NOT NULL");
                    }
                }
                return;
            }
        }
        this._expr.generateWhere(cb);
    }

    public String toString() {
        String str = null;
        switch (this._token) {
            case 45: {
                str = "-";
                break;
            }
            case 43: {
                str = "+";
                break;
            }
            case 169: {
                str = "NOT";
                break;
            }
            case 139: {
                return this._expr + " IS NULL";
            }
            case 173: {
                return this._expr + " IS NOT NULL";
            }
        }
        return str + " " + this._expr;
    }
}

