/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.AndExpr;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.TableCacheUpdate;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectQuery
extends AbstractQuery {
    private AbstractQuery _parentQuery;
    private boolean _isDistinct;
    private ArrayList<AmberExpr> _resultList;
    private AmberExpr _where;
    private ArrayList<AmberExpr> _orderList;
    private ArrayList<Boolean> _ascList;
    private ArrayList<AmberExpr> _groupList;
    private String _sql;
    private boolean _isTableReadOnly = false;
    private long _cacheTimeout = -1L;

    SelectQuery(String query) {
        super(query);
    }

    void setParentQuery(AbstractQuery parent) {
        this._parentQuery = parent;
    }

    @Override
    AbstractQuery getParentQuery() {
        return this._parentQuery;
    }

    void setDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
    }

    void setResultList(ArrayList<AmberExpr> resultList) {
        this._resultList = resultList;
    }

    public ArrayList<AmberExpr> getResultList() {
        return this._resultList;
    }

    int getResultCount() {
        return this._resultList.size();
    }

    Type getResultType(int index) {
        AmberExpr expr = this._resultList.get(index);
        return expr.getType();
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    void setGroupList(ArrayList<AmberExpr> groupList) {
        this._groupList = groupList;
    }

    void setOrderList(ArrayList<AmberExpr> orderList, ArrayList<Boolean> ascList) {
        this._orderList = orderList;
        this._ascList = ascList;
    }

    @Override
    public String getSQL() {
        return this._sql;
    }

    @Override
    public long getCacheMaxAge() {
        return this._cacheTimeout;
    }

    public boolean isCacheable() {
        return 100L <= this._cacheTimeout;
    }

    public boolean isTableReadOnly() {
        return this._isTableReadOnly;
    }

    void init() throws SQLException {
        FromItem item2;
        int i;
        if (this._where instanceof AndExpr) {
            AndExpr and = (AndExpr)this._where;
            ArrayList<AmberExpr> components = and.getComponents();
            for (int i2 = components.size() - 1; i2 >= 0; --i2) {
                JoinExpr link;
                AmberExpr component = components.get(i2);
                if (!(component instanceof JoinExpr) || !(link = (JoinExpr)component).bindToFromItem()) continue;
                components.remove(i2);
            }
            this._where = and.getSingle();
        }
        for (i = 0; i < this._fromList.size(); ++i) {
            AmberExpr joinWhere;
            boolean isTarget;
            item2 = (FromItem)this._fromList.get(i);
            JoinExpr join = item2.getJoinExpr();
            if (join == null) continue;
            FromItem joinParent = join.getJoinParent();
            FromItem joinTarget = join.getJoinTarget();
            boolean bl = isTarget = item2 == joinTarget;
            if (joinParent == null) continue;
            if (joinParent.getJoinExpr() == null && joinParent == joinTarget && !this.usesFromData(joinParent)) {
                this._fromList.remove(joinParent);
                this.replaceJoin(join);
                item2.setJoinExpr(null);
                i = -1;
                joinWhere = join.getWhere();
                if (joinWhere == null) continue;
                this._where = AndExpr.create(this._where, joinWhere);
                continue;
            }
            if (this.isJoinParent(item2) || item2 != joinTarget || this.usesFromData(item2)) continue;
            this._fromList.remove(item2);
            this.replaceJoin(join);
            i = -1;
            joinWhere = join.getWhere();
            if (joinWhere == null) continue;
            this._where = AndExpr.create(this._where, joinWhere);
        }
        for (i = 0; i < this._fromList.size(); ++i) {
            item2 = (FromItem)this._fromList.get(i);
            if (item2.getJoinExpr() == null) continue;
            item2.setOuterJoin(!this.isFromInnerJoin(item2));
        }
        this._cacheTimeout = 0x3FFFFFFFFFFFFFFFL;
        this._isTableReadOnly = true;
        for (FromItem item2 : this._fromList) {
            EntityType type = item2.getTableType();
            if (type != null) {
                long timeout = type.getCacheTimeout();
                if (timeout < this._cacheTimeout) {
                    this._cacheTimeout = timeout;
                }
                if (type.isReadOnly()) continue;
                this._isTableReadOnly = false;
                continue;
            }
            this._isTableReadOnly = false;
        }
        this._sql = this.generateLoadSQL();
    }

    boolean isJoinParent(FromItem item) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem subItem = (FromItem)this._fromList.get(i);
            if (subItem.getJoinExpr() == null || subItem.getJoinExpr().getJoinParent() != item) continue;
            return true;
        }
        return false;
    }

    boolean isFromInnerJoin(FromItem item) {
        return this.usesFrom(item, 1);
    }

    boolean usesFromData(FromItem item) {
        return this.usesFrom(item, 0);
    }

    boolean usesFrom(FromItem item, int type) {
        for (int j = 0; j < this._resultList.size(); ++j) {
            AmberExpr result = this._resultList.get(j);
            if (!result.usesFrom(item, type)) continue;
            return true;
        }
        return this._where != null && this._where.usesFrom(item, type);
    }

    void replaceJoin(JoinExpr join) {
        for (int i = 0; i < this._resultList.size(); ++i) {
            AmberExpr result = this._resultList.get(i);
            this._resultList.set(i, result.replaceJoin(join));
        }
        if (this._where != null) {
            this._where = this._where.replaceJoin(join);
        }
    }

    String generateLoadSQL() {
        int i;
        CharBuffer cb = CharBuffer.allocate();
        cb.append("SELECT ");
        if (this._isDistinct) {
            cb.append(" DISTINCT ");
        }
        for (int i2 = 0; i2 < this._resultList.size(); ++i2) {
            if (i2 != 0) {
                cb.append(", ");
            }
            AmberExpr expr = this._resultList.get(i2);
            expr.generateSelect(cb);
        }
        cb.append(" FROM ");
        boolean hasJoinExpr = false;
        for (i = 0; i < this._fromList.size(); ++i) {
            FromItem item = (FromItem)this._fromList.get(i);
            if (i != 0) {
                if (item.isOuterJoin()) {
                    cb.append(" LEFT OUTER JOIN ");
                } else {
                    cb.append(", ");
                    if (item.getJoinExpr() != null) {
                        hasJoinExpr = true;
                    }
                }
            }
            cb.append(item.getTable().getName());
            cb.append(" ");
            cb.append(item.getName());
            if (item.getJoinExpr() == null || !item.isOuterJoin()) continue;
            cb.append(" ON ");
            item.getJoinExpr().generateJoin(cb);
        }
        if (hasJoinExpr || this._where != null) {
            boolean hasExpr = false;
            cb.append(" WHERE ");
            for (int i3 = 0; i3 < this._fromList.size(); ++i3) {
                FromItem item = (FromItem)this._fromList.get(i3);
                JoinExpr expr = item.getJoinExpr();
                if (expr == null || item.isOuterJoin()) continue;
                if (hasExpr) {
                    cb.append(" AND ");
                }
                hasExpr = true;
                expr.generateJoin(cb);
            }
            if (this._where != null) {
                if (hasExpr) {
                    cb.append(" AND ");
                }
                hasExpr = true;
                this._where.generateWhere(cb);
            }
        }
        if (this._groupList != null) {
            cb.append(" GROUP BY ");
            for (i = 0; i < this._groupList.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                this._groupList.get(i).generateWhere(cb);
            }
        }
        if (this._orderList != null) {
            cb.append(" ORDER BY ");
            for (i = 0; i < this._orderList.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                this._orderList.get(i).generateSelect(cb);
                if (!Boolean.FALSE.equals(this._ascList.get(i))) continue;
                cb.append(" DESC");
            }
        }
        return cb.toString();
    }

    @Override
    void registerUpdates(CachedQuery query) {
        for (int i = 0; i < this._fromList.size(); ++i) {
            FromItem item = (FromItem)this._fromList.get(i);
            AmberEntityHome home = item.getEntityHome();
            TableCacheUpdate update = new TableCacheUpdate(query);
            home.addUpdate(update);
        }
    }

    public boolean invalidateTable(String table) {
        for (int i = this._fromList.size() - 1; i >= 0; --i) {
            FromItem from = (FromItem)this._fromList.get(i);
            if (!table.equals(from.getTable().getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new StringBuffer().append("SelectQuery[").append(this.getQueryString()).append("]").toString();
    }
}

