/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

public class OrExpr
extends AbstractAmberExpr {
    private ArrayList<AmberExpr> _components = new ArrayList();

    public boolean isBoolean() {
        return true;
    }

    void add(AmberExpr expr) {
        this._components.add(expr);
    }

    public AmberExpr bindSelect(QueryParser parser) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.bindSelect(parser);
            this._components.set(i, expr);
        }
        return this;
    }

    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (type == 1) {
            for (int i = 0; i < this._components.size(); ++i) {
                AmberExpr expr = this._components.get(i);
                if (!isNot && !expr.usesFrom(from, type, isNot)) {
                    return false;
                }
                if (!isNot || !expr.usesFrom(from, type, isNot)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            if (!expr.usesFrom(from, type)) continue;
            return true;
        }
        return false;
    }

    public AmberExpr replaceJoin(JoinExpr join) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.replaceJoin(join);
            this._components.set(i, expr);
        }
        return this;
    }

    AmberExpr getSingle() {
        if (this._components.size() == 0) {
            return null;
        }
        if (this._components.size() == 1) {
            return this._components.get(0);
        }
        return this;
    }

    public void generateWhere(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            expr.generateWhere(cb);
        }
        cb.append(')');
    }

    public void generateJoin(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            expr.generateJoin(cb);
        }
        cb.append(')');
    }

    public String toString() {
        if (this._components.size() == 1) {
            return this._components.get(0).toString();
        }
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" OR ");
            }
            AmberExpr expr = this._components.get(i);
            cb.append(expr);
        }
        cb.append(')');
        return cb.toString();
    }
}

