/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.jca;

import com.caucho.amber.AmberException;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.gen.AmberEnhancer;
import com.caucho.amber.query.CachedQuery;
import com.caucho.amber.query.CachedQueryKey;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.Type;
import com.caucho.amber.type.TypeManager;
import com.caucho.config.ConfigException;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class AmberManager {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/jca/AmberManager"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/jca/AmberManager"));
    private Path _configDirectory;
    private com.caucho.amber.AmberManager _manager = new com.caucho.amber.AmberManager();
    private TypeManager _typeManager = new TypeManager();
    private HashMap<String, AmberEntityHome> _entityHomeMap = new HashMap();
    private LruCache<CachedQueryKey, SoftReference<CachedQuery>> _queryCache = new LruCache(1024);
    private ArrayList<EntityType> _lazyConfigure = new ArrayList();
    private ArrayList<EntityType> _lazyInit = new ArrayList();
    private ArrayList<EntityType> _lazyStart = new ArrayList();
    private AmberEnhancer _enhancer;
    private volatile boolean _isInit;

    public com.caucho.amber.AmberManager getAmberManager() {
        return this._manager;
    }

    public void setDataSource(DataSource dataSource) {
        this._manager.setDataSource(dataSource);
    }

    public DataSource getDataSource() {
        return this._manager.getDataSource();
    }

    public void setConfigDirectory(Path configDirectory) {
        this._configDirectory = configDirectory;
    }

    public void setCreateDatabaseTables(boolean create) {
        this._manager.setCreateDatabaseTables(create);
    }

    public boolean getCreateDatabaseTables() {
        return this._manager.getCreateDatabaseTables();
    }

    public long getXid() {
        return this._manager.getXid();
    }

    public EntityType createEntity(Class beanClass) {
        return this.createEntity(beanClass.getName(), beanClass);
    }

    public EntityType createEntity(String name, Class beanClass) {
        return this._manager.createEntity(name, beanClass);
    }

    public void configureLazy() throws ConfigException, IOException {
        while (this._lazyConfigure.size() > 0) {
            EntityType type = this._lazyConfigure.remove(0);
            this._enhancer.configure(type);
        }
    }

    public void initLazy() throws ConfigException, IOException {
        while (this._lazyInit.size() > 0) {
            this.configureLazy();
            if (this._lazyInit.size() <= 0) continue;
            EntityType type = this._lazyInit.remove(0);
            type.init();
        }
    }

    public void startLazy() throws ConfigException, IOException {
        while (this._lazyStart.size() > 0) {
            this.initLazy();
            if (this._lazyStart.size() <= 0) continue;
            EntityType type = this._lazyStart.remove(0);
            type.start();
        }
    }

    public SubEntityType createSubEntity(Class beanClass, EntityType parent) {
        return this._manager.createSubEntity(beanClass, parent);
    }

    public AmberEntityHome getEntityHome(String name) {
        return this._manager.getEntityHome(name);
    }

    public EntityType getEntity(String className) {
        return this._manager.getEntity(className);
    }

    public Type createType(String typeName) throws ConfigException {
        return this._manager.createType(typeName);
    }

    public Type createType(Class javaType) throws ConfigException {
        return this._manager.createType(javaType);
    }

    public void init() throws ConfigException, IOException {
        this._enhancer = new AmberEnhancer();
        EnhancingClassLoader.enhance(this._enhancer);
        this._enhancer.setAmberManager(this._manager);
        this._enhancer.setConfigDirectory(this._configDirectory);
        if (this._configDirectory != null) {
            String[] list = this._configDirectory.list();
            for (int i = 0; i < list.length; ++i) {
                String name = list[i];
                if (!name.endsWith(".hbm.xml")) continue;
                Path path = this._configDirectory.lookup(name);
                this._enhancer.parseHibernateMapping(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEntityHomes() throws AmberException {
        AmberManager amberManager = this;
        synchronized (amberManager) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        Iterator<AmberEntityHome> iter = this._entityHomeMap.values().iterator();
        while (iter.hasNext()) {
            AmberEntityHome home = iter.next();
            try {
                home.init();
            }
            catch (ConfigException e) {
                throw new AmberException(e);
            }
        }
    }

    public AmberEntityHome getHome(Class cl) {
        return this.getEntityHome(cl.getName());
    }

    public String getCreateTableSQL(int sqlType, int length) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AmberManager[]";
    }
}

