/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.idgen;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class AmberTableGenerator
extends IdGenerator {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/idgen/AmberTableGenerator"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/idgen/AmberTableGenerator"));
    private AmberManager _manager;
    private GeneratorTableType _table;
    private String _name;
    private String _selectSQL;
    private String _updateSQL;
    private boolean _isInit;

    public AmberTableGenerator(AmberManager manager, GeneratorTableType table, String name) {
        this._manager = manager;
        this._table = table;
        this._name = name;
    }

    public long allocateGroup(AmberConnectionImpl aConn) throws SQLException {
        int groupSize = this.getGroupSize();
        int retry = 5;
        Connection conn = aConn.getConnection();
        PreparedStatement selectStmt = conn.prepareStatement(this._selectSQL);
        PreparedStatement updateStmt = conn.prepareStatement(this._updateSQL);
        selectStmt.setString(1, this._name);
        updateStmt.setString(2, this._name);
        while (retry-- > 0) {
            ResultSet rs = selectStmt.executeQuery();
            if (rs.next()) {
                long value = rs.getLong(1);
                rs.close();
                updateStmt.setLong(1, value + (long)groupSize);
                updateStmt.setLong(3, value);
                if (updateStmt.executeUpdate() == 1) {
                    return value;
                }
            }
            rs.close();
        }
        throw new SQLException(L.l("Can't allocate id from table '{0}'", this._table.getTable().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(AmberManager amberManager) throws SQLException {
        Connection conn;
        block6: {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            this._selectSQL = "SELECT " + this._table.getValueColumn() + " FROM " + this._table.getTable().getName() + " WHERE " + this._table.getKeyColumn() + "=?";
            this._updateSQL = "UPDATE " + this._table.getTable().getName() + " SET " + this._table.getValueColumn() + "=?" + " WHERE " + this._table.getKeyColumn() + "=? " + "  AND " + this._table.getValueColumn() + "=?";
            DataSource ds = amberManager.getDataSource();
            conn = ds.getConnection();
            try {
                PreparedStatement pstmt = conn.prepareStatement(this._selectSQL);
                pstmt.setString(1, this._name);
                ResultSet rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
                break block6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            conn.close();
            return;
        }
        String sql = "INSERT INTO " + this._table.getTable().getName() + " (" + this._table.getKeyColumn() + "," + this._table.getValueColumn() + ") VALUES " + "('" + this._name + "', 1)";
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
    }
}

